/*
 * Decompiled with CFR 0.152.
 */
package org.millenaire.common.goal;

import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import org.millenaire.common.InvItem;
import org.millenaire.common.MLN;
import org.millenaire.common.MillVillager;
import org.millenaire.common.goal.Goal;
import org.millenaire.common.item.Goods;

public class GoalMerchantVisitInn
extends Goal {
    @Override
    public Goal.GoalInformation getDestination(MillVillager villager) throws Exception {
        return this.packDest(villager.getHouse().getResManager().getSellingPos(), villager.getHouse());
    }

    @Override
    public ItemStack[] getHeldItemsTravelling(MillVillager villager) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (InvItem good : villager.getInventoryKeys()) {
            if (villager.countInv(good.getItem(), good.meta) <= 0) continue;
            items.add(new ItemStack(good.getItem(), 1, good.meta));
        }
        return items.toArray(new ItemStack[items.size()]);
    }

    @Override
    public boolean isPossibleSpecific(MillVillager villager) throws Exception {
        boolean delayOver = !villager.lastGoalTime.containsKey(this) ? true : villager.field_70170_p.func_72820_D() > villager.lastGoalTime.get(this) + 2000L;
        int nb = 0;
        for (InvItem invItem : villager.getInventoryKeys()) {
            int nbcount = villager.countInv(invItem.getItem(), invItem.meta);
            if (nbcount <= 0 || villager.getTownHall().nbGoodNeeded(invItem.getItem(), invItem.meta) != 0) continue;
            nb += nbcount;
            if (delayOver) {
                return true;
            }
            if (nb <= 64) continue;
            return true;
        }
        for (Goods goods : villager.getTownHall().culture.goodsList) {
            if (villager.getHouse().countGoods(goods.item.getItem(), goods.item.meta) <= 0 || villager.countInv(goods.item.getItem(), goods.item.meta) >= villager.getTownHall().nbGoodNeeded(goods.item.getItem(), goods.item.meta)) continue;
            if (MLN.LogMerchant >= 1) {
                MLN.major(this, "Visiting the Inn to take imports");
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean performAction(MillVillager villager) throws Exception {
        String s = "";
        for (InvItem invItem : villager.getInventoryKeys()) {
            int nb;
            if (villager.countInv(invItem.getItem(), invItem.meta) <= 0 || villager.getTownHall().nbGoodNeeded(invItem.getItem(), invItem.meta) != 0 || (nb = villager.putInBuilding(villager.getHouse(), invItem.getItem(), invItem.meta, 99999999)) <= 0) continue;
            s = s + ";" + invItem.getItem() + "/" + invItem.meta + "/" + nb;
        }
        if (s.length() > 0) {
            villager.getHouse().visitorsList.add("storedexports;" + villager.getName() + s);
        }
        s = "";
        for (Goods goods : villager.getTownHall().culture.goodsList) {
            int nb;
            int nbNeeded = villager.getTownHall().nbGoodNeeded(goods.item.getItem(), goods.item.meta);
            if (villager.countInv(goods.item.getItem(), goods.item.meta) >= nbNeeded || (nb = villager.takeFromBuilding(villager.getHouse(), goods.item.getItem(), goods.item.meta, nbNeeded - villager.countInv(goods.item.getItem(), goods.item.meta))) <= 0) continue;
            s = s + ";" + goods.item.getItem() + "/" + goods.item.meta + "/" + nb;
        }
        if (s.length() > 0) {
            villager.getHouse().visitorsList.add("broughtimport;" + villager.getName() + s);
        }
        return true;
    }

    @Override
    public int priority(MillVillager villager) throws Exception {
        return 100;
    }
}

