/*
 * Decompiled with CFR 0.152.
 */
package org.millenaire.common.goal;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.init.Blocks;
import org.millenaire.common.InvItem;
import org.millenaire.common.MLN;
import org.millenaire.common.MillVillager;
import org.millenaire.common.Point;
import org.millenaire.common.core.MillCommonUtilities;
import org.millenaire.common.goal.Goal;
import org.millenaire.common.pathing.atomicstryker.AStarConfig;

public class GoalShearSheep
extends Goal {
    public GoalShearSheep() {
        try {
            this.buildingLimit.put(new InvItem(Blocks.field_150325_L, 0), 1024);
            this.townhallLimit.put(new InvItem(Blocks.field_150325_L, 0), 1024);
        }
        catch (MLN.MillenaireException e) {
            MLN.printException(e);
        }
    }

    @Override
    public Goal.GoalInformation getDestination(MillVillager villager) throws Exception {
        Point pos = villager.getPos();
        Entity closestSheep = null;
        double sheepBestDist = Double.MAX_VALUE;
        List<Entity> sheep = MillCommonUtilities.getEntitiesWithinAABB(villager.field_70170_p, EntitySheep.class, villager.getHouse().getPos(), 30, 10);
        for (Entity ent : sheep) {
            if (((EntitySheep)ent).func_70892_o() || ((EntitySheep)ent).func_70631_g_() || closestSheep != null && !(pos.distanceTo(ent) < sheepBestDist)) continue;
            closestSheep = ent;
            sheepBestDist = pos.distanceTo(ent);
        }
        if (closestSheep != null) {
            return this.packDest(null, villager.getHouse(), closestSheep);
        }
        return null;
    }

    @Override
    public AStarConfig getPathingConfig() {
        return JPS_CONFIG_WIDE;
    }

    @Override
    public boolean isFightingGoal() {
        return true;
    }

    @Override
    public boolean isPossibleSpecific(MillVillager villager) throws Exception {
        if (!villager.getHouse().location.tags.contains("sheeps")) {
            return false;
        }
        List<Entity> sheep = MillCommonUtilities.getEntitiesWithinAABB(villager.field_70170_p, EntitySheep.class, villager.getHouse().getPos(), 30, 10);
        if (sheep == null) {
            return false;
        }
        for (Entity ent : sheep) {
            EntitySheep asheep = (EntitySheep)ent;
            if (asheep.func_70631_g_() || asheep.field_70128_L || ((EntitySheep)ent).func_70892_o()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean lookAtGoal() {
        return true;
    }

    @Override
    public boolean performAction(MillVillager villager) throws Exception {
        List<Entity> sheep = MillCommonUtilities.getEntitiesWithinAABB(villager.field_70170_p, EntitySheep.class, villager.getPos(), 4, 4);
        for (Entity ent : sheep) {
            EntitySheep animal;
            if (ent.field_70128_L || (animal = (EntitySheep)ent).func_70631_g_() || animal.func_70892_o()) continue;
            villager.addToInv(Blocks.field_150325_L, ((EntitySheep)ent).func_70896_n(), 3);
            ((EntitySheep)ent).func_70893_e(true);
            if (MLN.LogCattleFarmer >= 1 && villager.extraLog) {
                MLN.major(this, "Shearing: " + ent);
            }
            villager.func_71038_i();
        }
        return true;
    }

    @Override
    public int priority(MillVillager villager) throws Exception {
        return 50;
    }

    @Override
    public int range(MillVillager villager) {
        return 5;
    }
}

