/*
 * Decompiled with CFR 0.152.
 */
package org.millenaire.common.pathing.atomicstryker;

import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.minecraft.world.World;
import org.millenaire.common.MLN;
import org.millenaire.common.pathing.atomicstryker.AStarConfig;
import org.millenaire.common.pathing.atomicstryker.AStarNode;
import org.millenaire.common.pathing.atomicstryker.AStarStatic;
import org.millenaire.common.pathing.atomicstryker.AStarWorker;
import org.millenaire.common.pathing.atomicstryker.AStarWorkerJPS;
import org.millenaire.common.pathing.atomicstryker.IAStarPathedEntity;

public class AStarPathPlanner {
    private static ExecutorService executorService = Executors.newCachedThreadPool();
    private AStarWorker worker = new AStarWorker(this);
    private final World worldObj;
    private final IAStarPathedEntity pathedEntity;
    private boolean accesslock;
    private boolean isJPS;
    private AStarNode lastStart;
    private AStarNode lastEnd;
    public AStarConfig config;

    public AStarPathPlanner(World world, IAStarPathedEntity ent) {
        this.worldObj = world;
        this.accesslock = false;
        this.pathedEntity = ent;
        this.isJPS = true;
    }

    private void flushWorker() {
        if (!this.accesslock) {
            this.worker = this.isJPS ? new AStarWorkerJPS(this) : new AStarWorker(this);
        }
    }

    public void getPath(AStarNode start, AStarNode end, AStarConfig config) {
        if (this.isBusy()) {
            this.stopPathSearch(true);
        }
        while (this.accesslock) {
            Thread.yield();
        }
        this.flushWorker();
        this.accesslock = true;
        this.lastStart = start;
        this.lastEnd = end;
        this.config = config;
        this.worker.setup(this.worldObj, start, end, config.allowDropping);
        try {
            this.worker.isRunning = true;
            executorService.submit(this.worker);
        }
        catch (Exception e) {
            MLN.printException(e);
        }
        this.accesslock = false;
    }

    public void getPath(int startx, int starty, int startz, int destx, int desty, int destz, AStarConfig config) {
        if (!AStarStatic.isViable(this.worldObj, startx, starty, startz, 0, config)) {
            --starty;
        }
        if (!AStarStatic.isViable(this.worldObj, startx, starty, startz, 0, config)) {
            starty += 2;
        }
        if (!AStarStatic.isViable(this.worldObj, startx, starty, startz, 0, config)) {
            --starty;
        }
        AStarNode starter = new AStarNode(startx, starty, startz, 0, null);
        AStarNode finish = new AStarNode(destx, desty, destz, -1, null);
        this.getPath(starter, finish, config);
    }

    public boolean isBusy() {
        return this.worker.isBusy();
    }

    public void onFoundPath(ArrayList<AStarNode> result) {
        this.setJPS(true);
        if (this.pathedEntity != null) {
            this.pathedEntity.onFoundPath(result);
        }
    }

    public void onNoPathAvailable() {
        if (this.isJPS) {
            this.setJPS(false);
            this.getPath(this.lastStart, this.lastEnd, this.config);
            return;
        }
        if (this.pathedEntity != null) {
            this.pathedEntity.onNoPathAvailable();
        }
    }

    public void setJPS(boolean b) {
        this.isJPS = b;
        this.flushWorker();
    }

    public void stopPathSearch(boolean interrupted) {
        this.flushWorker();
        if (this.pathedEntity != null && !interrupted) {
            this.pathedEntity.onNoPathAvailable();
        }
    }
}

