/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.obfuscate.proxy;

import com.mrcrayfish.obfuscate.Obfuscate;
import com.mrcrayfish.obfuscate.client.model.CustomBipedModel;
import com.mrcrayfish.obfuscate.client.model.CustomPlayerModel;
import com.mrcrayfish.obfuscate.client.model.layer.CustomHeldItemLayer;
import com.mrcrayfish.obfuscate.client.renderer.entity.CustomItemRenderer;
import com.mrcrayfish.obfuscate.proxy.CommonProxy;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.PlayerRenderer;
import net.minecraft.client.renderer.entity.layers.BipedArmorLayer;
import net.minecraft.client.renderer.entity.layers.HeadLayer;
import net.minecraft.client.renderer.entity.layers.HeldItemLayer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.entity.item.ItemEntity;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class ClientProxy
extends CommonProxy {
    @Override
    public void setupClient() {
        RenderingRegistry.registerEntityRenderingHandler(ItemEntity.class, manager -> new CustomItemRenderer(manager, Minecraft.func_71410_x().func_175599_af()));
        this.patchPlayerModels();
    }

    private void patchPlayerModels() {
        Obfuscate.LOGGER.info("Starting to patch player models...");
        Map skinMap = Minecraft.func_71410_x().func_175598_ae().getSkinMap();
        this.patchPlayerRender((PlayerRenderer)skinMap.get("default"), false);
        this.patchPlayerRender((PlayerRenderer)skinMap.get("slim"), true);
    }

    private void patchPlayerRender(PlayerRenderer player, boolean smallArms) {
        CustomPlayerModel model = new CustomPlayerModel(0.0f, smallArms);
        List layers = (List)ObfuscationReflectionHelper.getPrivateValue(LivingRenderer.class, (Object)player, (String)"field_177097_h");
        if (layers != null) {
            layers.removeIf(layer -> layer instanceof HeldItemLayer || layer instanceof HeadLayer || layer instanceof BipedArmorLayer);
            layers.add(new CustomHeldItemLayer((IEntityRenderer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>>)player));
            layers.add(new HeadLayer((IEntityRenderer)player));
            layers.add(new BipedArmorLayer((IEntityRenderer)player, (BipedModel)new CustomBipedModel((BipedModel)model, 0.5f), (BipedModel)new CustomBipedModel((BipedModel)model, 1.0f)));
        }
        ObfuscationReflectionHelper.setPrivateValue(LivingRenderer.class, (Object)player, (Object)((Object)model), (String)"field_77045_g");
        Obfuscate.LOGGER.info("Patched " + (smallArms ? "slim" : "default") + " model successfully");
    }
}

