/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.obfuscate.client.model.layer;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mrcrayfish.obfuscate.client.event.RenderItemEvent;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.entity.model.IHasArm;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.HandSide;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

@OnlyIn(value=Dist.CLIENT)
public class CustomHeldItemLayer<T extends LivingEntity, M extends EntityModel<T>>
extends LayerRenderer<T, M> {
    public CustomHeldItemLayer(IEntityRenderer<T, M> renderer) {
        super(renderer);
    }

    public void render(MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int light, T entity, float p_225628_5_, float p_225628_6_, float partialTicks, float p_225628_8_, float p_225628_9_, float p_225628_10_) {
        ItemStack leftHandStack;
        boolean rightHanded = entity.func_184591_cq() == HandSide.RIGHT;
        ItemStack rightHandStack = rightHanded ? entity.func_184592_cb() : entity.func_184614_ca();
        ItemStack itemStack = leftHandStack = rightHanded ? entity.func_184614_ca() : entity.func_184592_cb();
        if (!rightHandStack.func_190926_b() || !leftHandStack.func_190926_b()) {
            matrixStack.func_227860_a_();
            if (this.func_215332_c().field_217114_e) {
                matrixStack.func_227861_a_(0.0, 0.75, 0.0);
                matrixStack.func_227862_a_(0.5f, 0.5f, 0.5f);
            }
            this.renderHeldItem((LivingEntity)entity, leftHandStack, ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, HandSide.RIGHT, matrixStack, renderTypeBuffer, light, partialTicks);
            this.renderHeldItem((LivingEntity)entity, rightHandStack, ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, HandSide.LEFT, matrixStack, renderTypeBuffer, light, partialTicks);
            matrixStack.func_227865_b_();
        }
    }

    private void renderHeldItem(LivingEntity entity, ItemStack stack, ItemCameraTransforms.TransformType transformType, HandSide handSide, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int light, float partialTicks) {
        if (!stack.func_190926_b()) {
            matrixStack.func_227860_a_();
            ((IHasArm)this.func_215332_c()).func_225599_a_(handSide, matrixStack);
            matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-90.0f));
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
            boolean leftHanded = handSide == HandSide.LEFT;
            matrixStack.func_227861_a_((double)((float)(leftHanded ? -1 : 1) / 16.0f), 0.125, -0.625);
            if (!MinecraftForge.EVENT_BUS.post((Event)new RenderItemEvent.Held.Pre(entity, stack, transformType, matrixStack, renderTypeBuffer, handSide, light, OverlayTexture.field_229196_a_, partialTicks))) {
                Minecraft.func_71410_x().func_175597_ag().func_228397_a_(entity, stack, transformType, leftHanded, matrixStack, renderTypeBuffer, light);
                MinecraftForge.EVENT_BUS.post((Event)new RenderItemEvent.Held.Post(entity, stack, transformType, matrixStack, renderTypeBuffer, handSide, light, OverlayTexture.field_229196_a_, partialTicks));
            }
            matrixStack.func_227865_b_();
        }
    }
}

