/*
 * Decompiled with CFR 0.152.
 */
package com.performant.coremod.entity.ai;

import com.performant.coremod.Performant;
import com.performant.coremod.config.Configuration;
import com.performant.coremod.entity.ai.goals.CustomPriotizedSlowedGoal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.profiler.Profiler;

public class CustomGoalSelector
extends EntityAITasks {
    public final List<CustomPriotizedSlowedGoal> goals = new ArrayList<CustomPriotizedSlowedGoal>();
    private Profiler profiler;
    private int disabledFlags = 0;
    private int runningFlags = 0;
    private int runningNoOverRuleFlags = 0;
    public int trackingPlayers = 0;
    int counter = 0;
    public static final int SHOULD_EXECUTE_INTERVAL = Configuration.ai.goalSelectorTickRate - 1;

    public CustomGoalSelector(EntityAITasks old) {
        super(old.field_75781_c);
        this.importFrom(old);
        this.field_75782_a = old.field_75782_a;
        this.field_75781_c = old.field_75781_c;
        this.counter = new Random().nextInt(SHOULD_EXECUTE_INTERVAL + 1);
    }

    public void importFrom(EntityAITasks selector) {
        if (selector == null) {
            return;
        }
        for (EntityAITasks.EntityAITaskEntry task : selector.field_75782_a) {
            CustomPriotizedSlowedGoal goal = Performant.goalData.getPriotizedGoalFor(task.field_75731_b, task.field_75733_a, this);
            goal.isrunning = task.field_188524_c;
            if (task.field_188524_c && !task.field_75733_a.func_75252_g()) {
                this.runningNoOverRuleFlags |= task.field_75733_a.func_75247_h();
            }
            this.goals.add(goal);
        }
        this.goals.sort(Comparator.comparingInt(CustomPriotizedSlowedGoal::getPriority));
        this.profiler = selector.field_75781_c;
        this.disabledFlags = selector.field_188529_g;
    }

    public void func_75776_a(int priority, EntityAIBase task) {
        this.goals.add(Performant.goalData.getPriotizedGoalFor(priority, task, this));
        this.goals.sort(Comparator.comparingInt(CustomPriotizedSlowedGoal::getPriority));
    }

    public void func_85156_a(EntityAIBase task) {
        this.goals.stream().filter(goal -> goal.goal == task).filter(CustomPriotizedSlowedGoal::isRunning).forEach(this::resetGoal);
        this.goals.removeIf(goal -> goal.goal == task);
    }

    private boolean goalContainsDisabledFlag(CustomPriotizedSlowedGoal goal) {
        return (this.disabledFlags & goal.goal.func_75247_h()) != 0;
    }

    private boolean isPreemptedByAll(CustomPriotizedSlowedGoal goal1) {
        return (this.runningFlags & goal1.goal.func_75247_h()) == 0 && (this.runningNoOverRuleFlags & goal1.goal.func_75247_h()) == 0;
    }

    private void resetGoal(CustomPriotizedSlowedGoal goal) {
        if (goal.isrunning && !goal.goal.func_75252_g()) {
            this.runningNoOverRuleFlags &= ~goal.goal.func_75247_h();
        }
        goal.goal.func_75251_c();
        goal.isrunning = false;
    }

    public void func_75774_a() {
        this.profiler.func_76320_a("goalUpdate");
        ++this.counter;
        this.runningFlags = 0;
        for (CustomPriotizedSlowedGoal currentGoal : this.goals) {
            if (currentGoal.isRunning() && (this.goalContainsDisabledFlag(currentGoal) || currentGoal.goal.func_75252_g() && (this.runningFlags & currentGoal.goal.func_75247_h()) != 0 || !currentGoal.shouldContinueExecuting())) {
                this.resetGoal(currentGoal);
            }
            if (this.counter == 1 && !currentGoal.isRunning() && !this.goalContainsDisabledFlag(currentGoal) && this.isPreemptedByAll(currentGoal) && currentGoal.shouldExecute()) {
                if (!currentGoal.goal.func_75252_g()) {
                    this.runningNoOverRuleFlags |= currentGoal.goal.func_75247_h();
                }
                currentGoal.goal.func_75249_e();
                currentGoal.isrunning = true;
            }
            if (!currentGoal.isRunning()) continue;
            this.runningFlags |= currentGoal.goal.func_75247_h();
            currentGoal.updateTask();
        }
        if (this.counter > SHOULD_EXECUTE_INTERVAL) {
            this.counter = 0;
        }
        this.profiler.func_76319_b();
    }

    public boolean func_188528_b(int flag) {
        return (this.field_188529_g & flag) > 0;
    }

    public void func_188526_c(int flag) {
        this.field_188529_g |= flag;
    }

    public void func_188525_d(int flag) {
        this.field_188529_g &= ~flag;
    }

    public void func_188527_a(int flag, boolean enable) {
        if (enable) {
            this.func_188525_d(flag);
        } else {
            this.func_188526_c(flag);
        }
    }
}

