/*
 * Decompiled with CFR 0.152.
 */
package com.performant.coremod.entity.ai;

import com.performant.coremod.config.Configuration;
import com.performant.coremod.entity.ai.CustomGoalSelector;
import com.performant.coremod.entity.ai.goals.CustomPriotizedSlowedGoal;
import java.util.HashMap;
import java.util.function.Function;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWander;

public class CustomGoalTypeData {
    private final HashMap<Class<? extends EntityAIBase>, CustomGoalTypeParameter> GOAL_TYPES = new HashMap();

    public CustomGoalTypeData() {
        this.GOAL_TYPES.put(EntityAISwimming.class, new CustomGoalTypeParameter(g2 -> g2, 5, 1, Configuration.ai.slowerSwimmingAI));
        this.GOAL_TYPES.put(EntityAITempt.class, new CustomGoalTypeParameter(g2 -> g2, 4, 10, Configuration.ai.slowerTemptCheck));
        this.GOAL_TYPES.put(EntityAIWander.class, new CustomGoalTypeParameter(g2 -> g2, 4, 1, Configuration.ai.slowerWander));
    }

    public CustomPriotizedSlowedGoal getPriotizedGoalFor(int priority, EntityAIBase goal, CustomGoalSelector selector) {
        CustomGoalTypeParameter params = this.GOAL_TYPES.get(goal.getClass());
        if (params != null && params.isEnabled) {
            return new CustomPriotizedSlowedGoal(priority, params.goalConverter.apply(goal), selector, params.shouldExecuteRate, params.tickRate);
        }
        return new CustomPriotizedSlowedGoal(priority, goal, selector, 1, 1);
    }

    public class CustomGoalTypeParameter {
        public final Function<EntityAIBase, EntityAIBase> goalConverter;
        public final int shouldExecuteRate;
        public final int tickRate;
        public final boolean isEnabled;

        private CustomGoalTypeParameter(Function<EntityAIBase, EntityAIBase> goalConverter, int shouldExecuteRate, int tickRate, boolean isEnabled) {
            this.goalConverter = goalConverter;
            this.shouldExecuteRate = shouldExecuteRate;
            this.tickRate = tickRate;
            this.isEnabled = isEnabled;
        }
    }
}

