/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.configuration;

import java.io.Serializable;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import org.cache2k.configuration.CacheType;

public class CacheTypeCapture<T>
implements CacheType<T> {
    private final CacheType<T> descriptor = CacheTypeCapture.of(((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0]);

    protected CacheTypeCapture() {
    }

    public static <T> CacheType<T> of(Class<T> t) {
        return CacheTypeCapture.of(t);
    }

    public static CacheType of(Type t) {
        if (t instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)t;
            Class c = (Class)pt.getRawType();
            CacheType[] ta = new CacheType[pt.getActualTypeArguments().length];
            for (int i = 0; i < ta.length; ++i) {
                ta[i] = CacheTypeCapture.of(pt.getActualTypeArguments()[i]);
            }
            return new OfGeneric(c, ta);
        }
        if (t instanceof GenericArrayType) {
            GenericArrayType gat = (GenericArrayType)t;
            return new OfArray(CacheTypeCapture.of(gat.getGenericComponentType()));
        }
        if (!(t instanceof Class)) {
            throw new IllegalArgumentException("The run time type is not available, got: " + t);
        }
        Class c = (Class)t;
        if (c.isArray()) {
            return new OfArray(CacheTypeCapture.of(c.getComponentType()));
        }
        return new OfClass(c);
    }

    @Override
    public CacheType<T> getBeanRepresentation() {
        return this.descriptor;
    }

    @Override
    public CacheType<?> getComponentType() {
        return this.descriptor.getComponentType();
    }

    @Override
    public Class<T> getType() {
        return this.descriptor.getType();
    }

    @Override
    public CacheType<?>[] getTypeArguments() {
        return this.descriptor.getTypeArguments();
    }

    @Override
    public String getTypeName() {
        return this.descriptor.getTypeName();
    }

    @Override
    public boolean hasTypeArguments() {
        return this.descriptor.hasTypeArguments();
    }

    @Override
    public boolean isArray() {
        return this.descriptor.isArray();
    }

    public boolean equals(Object o) {
        return this.descriptor.equals(o);
    }

    public int hashCode() {
        return this.descriptor.hashCode();
    }

    static String arrayToString(CacheType[] a) {
        if (a.length < 1) {
            throw new IllegalArgumentException();
        }
        StringBuilder sb = new StringBuilder();
        int l = a.length - 1;
        int i = 0;
        while (true) {
            sb.append(a[i].getTypeName());
            if (i == l) {
                return sb.toString();
            }
            sb.append(',');
            ++i;
        }
    }

    public static class OfGeneric
    extends BaseType {
        CacheType[] typeArguments;
        Class<?> type;

        public OfGeneric() {
        }

        public OfGeneric(Class<?> type, CacheType[] typeArguments) {
            this.typeArguments = typeArguments;
            this.type = type;
        }

        @Override
        public Class<?> getType() {
            return this.type;
        }

        public void setType(Class<?> type) {
            this.type = type;
        }

        @Override
        public boolean hasTypeArguments() {
            return true;
        }

        @Override
        public CacheType[] getTypeArguments() {
            return this.typeArguments;
        }

        public void setTypeArguments(CacheType[] typeArguments) {
            this.typeArguments = typeArguments;
        }

        @Override
        public String getTypeName() {
            return OfClass.shortenName(this.type.getCanonicalName()) + "<" + CacheTypeCapture.arrayToString(this.typeArguments) + '>';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OfGeneric that = (OfGeneric)o;
            return Arrays.equals(this.typeArguments, that.typeArguments) && this.type.equals(that.type);
        }

        public int hashCode() {
            int result = Arrays.hashCode(this.typeArguments);
            result = 31 * result + this.type.hashCode();
            return result;
        }
    }

    public static class OfArray
    extends BaseType {
        CacheType componentType;

        public OfArray() {
        }

        public OfArray(CacheType componentType) {
            this.componentType = componentType;
        }

        @Override
        public boolean isArray() {
            return true;
        }

        @Override
        public CacheType getComponentType() {
            return this.componentType;
        }

        public void setComponentType(CacheType componentType) {
            this.componentType = componentType;
        }

        static int countDimensions(CacheType td) {
            int cnt = 0;
            while (td.isArray()) {
                td = td.getComponentType();
                ++cnt;
            }
            return cnt;
        }

        static Class<?> finalPrimitiveType(CacheType td) {
            while (td.isArray()) {
                td = td.getComponentType();
            }
            return td.getType();
        }

        @Override
        public String getTypeName() {
            StringBuilder sb = new StringBuilder();
            int _dimensions = OfArray.countDimensions(this);
            if (_dimensions > 1) {
                sb.append(OfArray.finalPrimitiveType(this));
            } else {
                sb.append(this.getComponentType().getTypeName());
            }
            for (int i = 0; i < _dimensions; ++i) {
                sb.append("[]");
            }
            return sb.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OfArray arrayType = (OfArray)o;
            return this.componentType.equals(arrayType.componentType);
        }

        public int hashCode() {
            return this.componentType.hashCode();
        }
    }

    public static class OfClass
    extends BaseType {
        Class<?> type;

        public OfClass() {
        }

        public OfClass(Class<?> type) {
            if (type.isArray()) {
                throw new IllegalArgumentException("array is not a regular class");
            }
            this.type = type;
        }

        @Override
        public Class<?> getType() {
            return this.type;
        }

        public void setType(Class<?> type) {
            this.type = type;
        }

        static String shortenName(String s2) {
            String _LANG_PREFIX = "java.lang.";
            if (s2.startsWith("java.lang.")) {
                return s2.substring("java.lang.".length());
            }
            return s2;
        }

        @Override
        public String getTypeName() {
            return OfClass.shortenName(this.type.getCanonicalName());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OfClass classType = (OfClass)o;
            return this.type.equals(classType.type);
        }

        public int hashCode() {
            return this.type.hashCode();
        }
    }

    private static abstract class BaseType
    implements CacheType,
    Serializable {
        private BaseType() {
        }

        public CacheType getComponentType() {
            return null;
        }

        public Class getType() {
            return null;
        }

        public CacheType[] getTypeArguments() {
            return null;
        }

        @Override
        public boolean hasTypeArguments() {
            return false;
        }

        @Override
        public boolean isArray() {
            return false;
        }

        public CacheType getBeanRepresentation() {
            return this;
        }

        public final String toString() {
            return "CacheTypeDescriptor#" + this.getTypeName();
        }
    }
}

