/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core;

import java.io.Closeable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.cache2k.Cache;
import org.cache2k.CacheEntry;
import org.cache2k.CacheException;
import org.cache2k.CustomizationException;
import org.cache2k.configuration.CustomizationSupplier;
import org.cache2k.core.CacheClosedException;
import org.cache2k.core.CacheMXBeanImpl;
import org.cache2k.core.ConcurrentMapWrapper;
import org.cache2k.core.Entry;
import org.cache2k.core.EntryAction;
import org.cache2k.core.InternalCache;
import org.cache2k.core.InternalCacheInfo;
import org.cache2k.core.operation.Semantic;
import org.cache2k.core.storageApi.StorageAdapter;
import org.cache2k.jmx.CacheInfoMXBean;
import org.cache2k.processor.EntryProcessingException;
import org.cache2k.processor.EntryProcessingResult;
import org.cache2k.processor.EntryProcessor;

public abstract class BaseCache<K, V>
implements InternalCache<K, V> {
    public static String nameQualifier(Cache cache) {
        StringBuilder sb = new StringBuilder();
        sb.append('\'').append(cache.getName()).append('\'');
        if (!cache.getCacheManager().isDefaultManager()) {
            sb.append(", manager='").append(cache.getCacheManager().getName()).append('\'');
        }
        return sb.toString();
    }

    protected abstract Iterator<CacheEntry<K, V>> iterator();

    @Override
    public Iterable<K> keys() {
        return new Iterable<K>(){

            @Override
            public Iterator<K> iterator() {
                final Iterator it = BaseCache.this.iterator();
                return new Iterator<K>(){

                    @Override
                    public boolean hasNext() {
                        return it.hasNext();
                    }

                    @Override
                    public K next() {
                        return ((CacheEntry)it.next()).getKey();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    @Override
    public Iterable<CacheEntry<K, V>> entries() {
        return new Iterable<CacheEntry<K, V>>(){

            @Override
            public Iterator<CacheEntry<K, V>> iterator() {
                return BaseCache.this.iterator();
            }
        };
    }

    @Override
    public void removeAll() {
        this.removeAll(this.keys());
    }

    @Override
    public void removeAll(Iterable<? extends K> _keys) {
        for (K k : _keys) {
            this.remove(k);
        }
    }

    @Override
    public <X> X requestInterface(Class<X> _type) {
        if (_type.equals(ConcurrentMap.class) || _type.equals(Map.class)) {
            return (X)new ConcurrentMapWrapper(this);
        }
        if (_type.isAssignableFrom(this.getClass())) {
            return (X)this;
        }
        return null;
    }

    @Override
    public ConcurrentMap<K, V> asMap() {
        return new ConcurrentMapWrapper(this);
    }

    @Override
    public StorageAdapter getStorage() {
        return null;
    }

    @Override
    public <R> Map<K, EntryProcessingResult<R>> invokeAll(Iterable<? extends K> keys, EntryProcessor<K, V, R> entryProcessor) {
        HashMap m3 = new HashMap();
        for (K k : keys) {
            try {
                final R _result = this.invoke(k, entryProcessor);
                if (_result == null) continue;
                m3.put(k, new EntryProcessingResult<R>(){

                    @Override
                    public R getResult() {
                        return _result;
                    }

                    @Override
                    public Throwable getException() {
                        return null;
                    }
                });
            }
            catch (EntryProcessingException t) {
                final Throwable _cause = t.getCause();
                m3.put(k, new EntryProcessingResult<R>(){

                    @Override
                    public R getResult() {
                        throw new EntryProcessingException(_cause);
                    }

                    @Override
                    public Throwable getException() {
                        return _cause;
                    }
                });
            }
        }
        return m3;
    }

    protected <R> R execute(K key, Entry<K, V> e, Semantic<K, V, R> op) {
        EntryAction<K, V, R> _action = this.createEntryAction(key, e, op);
        return this.execute(op, _action);
    }

    protected abstract <R> EntryAction<K, V, R> createEntryAction(K var1, Entry<K, V> var2, Semantic<K, V, R> var3);

    protected <R> R execute(Semantic<K, V, R> op, EntryAction<K, V, R> _action) {
        op.start(_action);
        RuntimeException t = _action.exceptionToPropagate;
        if (t != null) {
            t.fillInStackTrace();
            throw t;
        }
        return _action.result;
    }

    protected <R> R execute(K key, Semantic<K, V, R> op) {
        return this.execute(key, null, op);
    }

    @Override
    public <T> T createCustomization(CustomizationSupplier<T> f) {
        if (f == null) {
            return null;
        }
        try {
            return f.supply(this.getCacheManager());
        }
        catch (Exception ex) {
            throw new CustomizationException("Initialization of customization failed", ex);
        }
    }

    @Override
    public void closeCustomization(Object _customization, String _customizationName) {
        if (_customization instanceof Closeable) {
            try {
                ((Closeable)_customization).close();
            }
            catch (Exception e) {
                String _message = _customizationName + ".close() exception (" + BaseCache.nameQualifier(this) + ")";
                throw new CacheException(_message, e);
            }
        }
    }

    @Override
    public void clearAndClose() {
        this.close();
    }

    @Override
    public String toString() {
        try {
            InternalCacheInfo fo = this.getLatestInfo();
            return fo.toString();
        }
        catch (CacheClosedException ex) {
            return "Cache(name=" + BaseCache.nameQualifier(this) + ", closed=true)";
        }
    }

    @Override
    public CacheInfoMXBean getStatistics() {
        return new CacheMXBeanImpl(this);
    }
}

