/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core;

import org.cache2k.IntCache;
import org.cache2k.core.Entry;
import org.cache2k.core.Hash2;
import org.cache2k.core.HeapCache;

public class IntHeapCache<V>
extends HeapCache<Integer, V>
implements IntCache<V> {
    @Override
    public Integer extractIntKeyObj(Integer key) {
        return null;
    }

    @Override
    public int extractIntKeyValue(Integer key, int hc) {
        return key;
    }

    @Override
    public int extractModifiedHash(Entry e) {
        return IntHeapCache.modifiedHash(e.hashCode);
    }

    @Override
    public Integer extractKeyObj(Entry<Integer, V> e) {
        return e.hashCode;
    }

    @Override
    public Hash2<Integer, V> createHashTable() {
        return new Hash2<Integer, V>(this){

            @Override
            protected int modifiedHashCode(int hc) {
                return IntHeapCache.modifiedHash(hc);
            }

            @Override
            protected boolean keyObjIsEqual(Integer key, Entry e) {
                return true;
            }
        };
    }

    @Override
    public V peek(int key) {
        Entry e = this.peekEntryInternal(null, IntHeapCache.modifiedHash(key), key);
        if (e != null) {
            return this.returnValue(e);
        }
        return null;
    }

    @Override
    public boolean containsKey(int key) {
        Entry e = this.lookupEntry(null, IntHeapCache.modifiedHash(key), key);
        if (e != null) {
            this.metrics.heapHitButNoRead();
            return e.hasFreshData(this.clock);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void put(int key, V value) {
        Entry e;
        while (true) {
            Entry entry = e = this.lookupOrNewEntry(null, IntHeapCache.modifiedHash(key), key);
            synchronized (entry) {
                e.waitForProcessing();
                if (!e.isGone()) break;
                this.metrics.goneSpin();
            }
        }
        {
            if (!e.isVirgin()) {
                this.metrics.heapHitButNoRead();
            }
            this.putValue(e, value);
            return;
        }
    }

    @Override
    public V get(int key) {
        Entry e = this.getEntryInternal(null, IntHeapCache.modifiedHash(key), key);
        if (e == null) {
            return null;
        }
        return this.returnValue(e);
    }

    @Override
    public void remove(int key) {
        super.remove(key);
    }
}

