/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import org.cache2k.core.util.LogFactory;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Log {
    private static Map<String, Log> loggers = new HashMap<String, Log>();
    private static LogFactory logFactory;

    public static Log getLog(Class<?> _class) {
        return Log.getLog(_class.getName());
    }

    public static synchronized Log getLog(String s2) {
        Log l = loggers.get(s2);
        if (l != null) {
            return l;
        }
        if (logFactory == null) {
            Log.initializeLogFactory();
        }
        l = logFactory.getLog(s2);
        loggers.put(s2, l);
        return l;
    }

    private static void log(String s2) {
        Log.getLog(Log.class.getName()).debug(s2);
    }

    private static void initializeLogFactory() {
        ServiceLoader<LogFactory> loader = ServiceLoader.load(LogFactory.class);
        Iterator<LogFactory> iterator = loader.iterator();
        if (iterator.hasNext()) {
            LogFactory lf;
            logFactory = lf = iterator.next();
            Log.log("New instance, using: " + logFactory.getClass().getName());
            return;
        }
        try {
            final ILoggerFactory lf = LoggerFactory.getILoggerFactory();
            logFactory = new LogFactory(){

                @Override
                public Log getLog(String s2) {
                    return new Slf4jLogger(lf.getLogger(s2));
                }
            };
            Log.log("New instance, using SLF4J logging");
            return;
        }
        catch (NoClassDefFoundError lf) {
            try {
                final org.apache.commons.logging.LogFactory cl = org.apache.commons.logging.LogFactory.getFactory();
                logFactory = new LogFactory(){

                    @Override
                    public Log getLog(String s2) {
                        return new CommonsLogger(cl.getInstance(s2));
                    }
                };
                Log.log("New instance, using commons logging");
                return;
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                logFactory = new LogFactory(){

                    @Override
                    public Log getLog(String s2) {
                        return new JdkLogger(java.util.logging.Logger.getLogger(s2));
                    }
                };
                Log.log("New instance, using JDK logging");
                return;
            }
        }
    }

    public static synchronized void registerSuppression(String s2, Log l) {
        loggers.put(s2, l);
    }

    public static synchronized void deregisterSuppression(String s2) {
        loggers.remove(s2);
    }

    public abstract boolean isDebugEnabled();

    public abstract boolean isInfoEnabled();

    public abstract void debug(String var1);

    public abstract void debug(String var1, Throwable var2);

    public abstract void info(String var1);

    public abstract void info(String var1, Throwable var2);

    public abstract void warn(String var1);

    public abstract void warn(String var1, Throwable var2);

    public static class SuppressionCounter
    extends Log {
        AtomicInteger debugCount = new AtomicInteger();
        AtomicInteger infoCount = new AtomicInteger();
        AtomicInteger warnCount = new AtomicInteger();

        @Override
        public boolean isDebugEnabled() {
            return true;
        }

        @Override
        public boolean isInfoEnabled() {
            return true;
        }

        @Override
        public void debug(String s2) {
            this.debugCount.incrementAndGet();
        }

        @Override
        public void debug(String s2, Throwable ex) {
            this.debugCount.incrementAndGet();
        }

        @Override
        public void info(String s2, Throwable ex) {
            this.infoCount.incrementAndGet();
        }

        @Override
        public void info(String s2) {
            this.infoCount.incrementAndGet();
        }

        @Override
        public void warn(String s2) {
            this.warnCount.incrementAndGet();
        }

        @Override
        public void warn(String s2, Throwable ex) {
            this.warnCount.incrementAndGet();
        }

        public int getDebugCount() {
            return this.debugCount.get();
        }

        public int getInfoCount() {
            return this.infoCount.get();
        }

        public int getWarnCount() {
            return this.warnCount.get();
        }
    }

    private static class JdkLogger
    extends Log {
        java.util.logging.Logger logger;

        private JdkLogger(java.util.logging.Logger logger) {
            this.logger = logger;
        }

        @Override
        public boolean isDebugEnabled() {
            return this.logger.isLoggable(Level.FINE);
        }

        @Override
        public boolean isInfoEnabled() {
            return this.logger.isLoggable(Level.INFO);
        }

        @Override
        public void debug(String s2) {
            this.logger.logp(Level.FINE, null, null, s2);
        }

        @Override
        public void debug(String s2, Throwable ex) {
            this.logger.logp(Level.FINE, s2, null, null, ex);
        }

        @Override
        public void info(String s2) {
            this.logger.logp(Level.INFO, null, null, s2);
        }

        @Override
        public void info(String s2, Throwable ex) {
            this.logger.logp(Level.INFO, null, null, s2, ex);
        }

        @Override
        public void warn(String s2) {
            this.logger.logp(Level.WARNING, null, null, s2);
        }

        @Override
        public void warn(String s2, Throwable ex) {
            this.logger.logp(Level.WARNING, null, null, s2, ex);
        }
    }

    private static class Slf4jLogger
    extends Log {
        Logger logger;

        private Slf4jLogger(Logger _logger) {
            this.logger = _logger;
        }

        @Override
        public boolean isDebugEnabled() {
            return this.logger.isDebugEnabled();
        }

        @Override
        public boolean isInfoEnabled() {
            return this.logger.isInfoEnabled();
        }

        @Override
        public void debug(String s2) {
            this.logger.debug(s2);
        }

        @Override
        public void debug(String s2, Throwable ex) {
            this.logger.debug(s2, ex);
        }

        @Override
        public void info(String s2, Throwable ex) {
            this.logger.info(s2);
        }

        @Override
        public void info(String s2) {
            this.logger.info(s2);
        }

        @Override
        public void warn(String s2) {
            this.logger.warn(s2);
        }

        @Override
        public void warn(String s2, Throwable ex) {
            this.logger.warn(s2, ex);
        }
    }

    private static class CommonsLogger
    extends Log {
        org.apache.commons.logging.Log cLog;

        private CommonsLogger(org.apache.commons.logging.Log cLog) {
            this.cLog = cLog;
        }

        @Override
        public boolean isDebugEnabled() {
            return this.cLog.isDebugEnabled();
        }

        @Override
        public boolean isInfoEnabled() {
            return this.cLog.isInfoEnabled();
        }

        @Override
        public void debug(String s2) {
            this.cLog.debug((Object)s2);
        }

        @Override
        public void debug(String s2, Throwable ex) {
            this.cLog.debug((Object)s2, ex);
        }

        @Override
        public void info(String s2, Throwable ex) {
            this.cLog.info((Object)s2);
        }

        @Override
        public void info(String s2) {
            this.cLog.info((Object)s2);
        }

        @Override
        public void warn(String s2) {
            this.cLog.warn((Object)s2);
        }

        @Override
        public void warn(String s2, Throwable ex) {
            this.cLog.warn((Object)s2, ex);
        }
    }
}

