/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.impl.serverSide;

import java.lang.management.ManagementFactory;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.cache2k.Cache;
import org.cache2k.CacheException;
import org.cache2k.CacheManager;
import org.cache2k.configuration.Cache2kConfiguration;
import org.cache2k.core.CacheManagerImpl;
import org.cache2k.core.spi.CacheLifeCycleListener;
import org.cache2k.core.spi.CacheManagerLifeCycleListener;
import org.cache2k.core.util.Log;
import org.cache2k.impl.serverSide.ManagerMXBeanImpl;

public class JmxSupport
implements CacheLifeCycleListener,
CacheManagerLifeCycleListener {
    private static final String REGISTERED_FLAG;
    private static final boolean MANAGEMENT_UNAVAILABLE;
    private Log log = Log.getLog(JmxSupport.class);

    @Override
    public void cacheCreated(Cache c, Cache2kConfiguration cfg) {
        if (MANAGEMENT_UNAVAILABLE || !cfg.isEnableJmx()) {
            return;
        }
        MBeanServer mbs = JmxSupport.getPlatformMBeanServer();
        String _name = this.standardName(c.getCacheManager(), c);
        try {
            mbs.registerMBean(c.getStatistics(), new ObjectName(_name));
        }
        catch (InstanceAlreadyExistsException ignore) {
            this.log.debug("register failure, cache: " + c.getName(), ignore);
        }
        catch (Exception e) {
            throw new CacheException("register JMX bean, ObjectName: " + _name, e);
        }
    }

    @Override
    public void cacheDestroyed(Cache c) {
        if (MANAGEMENT_UNAVAILABLE) {
            return;
        }
        MBeanServer mbs = JmxSupport.getPlatformMBeanServer();
        String _name = this.standardName(c.getCacheManager(), c);
        try {
            mbs.unregisterMBean(new ObjectName(_name));
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
        }
        catch (Exception e) {
            throw new CacheException("unregister JMX bean, ObjectName: " + _name, e);
        }
    }

    @Override
    public void managerCreated(CacheManager m3) {
        if (MANAGEMENT_UNAVAILABLE) {
            return;
        }
        MBeanServer mbs = JmxSupport.getPlatformMBeanServer();
        ManagerMXBeanImpl _mBean = new ManagerMXBeanImpl((CacheManagerImpl)m3);
        String _name = JmxSupport.managerName(m3);
        try {
            mbs.registerMBean(_mBean, new ObjectName(_name));
            m3.getProperties().put(REGISTERED_FLAG, (Object)true);
            this.log.debug("Manager created and registered as: " + _name);
        }
        catch (InstanceAlreadyExistsException ignore) {
            this.log.debug("register failure, manager: " + m3.getName(), ignore);
        }
        catch (Exception e) {
            throw new CacheException("register JMX bean, ObjectName: " + _name, e);
        }
    }

    @Override
    public void managerDestroyed(CacheManager m3) {
        if (MANAGEMENT_UNAVAILABLE) {
            return;
        }
        if (!m3.getProperties().containsKey(REGISTERED_FLAG)) {
            return;
        }
        MBeanServer mbs = JmxSupport.getPlatformMBeanServer();
        String _name = JmxSupport.managerName(m3);
        try {
            mbs.unregisterMBean(new ObjectName(_name));
        }
        catch (Exception e) {
            throw new CacheException("Error unregister JMX bean, ObjectName: " + _name, e);
        }
    }

    private static MBeanServer getPlatformMBeanServer() {
        return ManagementFactory.getPlatformMBeanServer();
    }

    private static String managerName(CacheManager cm) {
        return "org.cache2k:type=CacheManager,name=" + JmxSupport.sanitizeNameAsJmxValue(cm.getName());
    }

    private String standardName(CacheManager cm, Cache c) {
        return "org.cache2k:type=Cache,manager=" + JmxSupport.sanitizeNameAsJmxValue(cm.getName()) + ",name=" + JmxSupport.sanitizeNameAsJmxValue(c.getName());
    }

    private static String sanitizeNameAsJmxValue(String s2) {
        if (s2.indexOf(44) >= 0) {
            return '\"' + s2 + '\"';
        }
        return s2;
    }

    static {
        boolean v;
        REGISTERED_FLAG = JmxSupport.class.getName() + ".registered";
        try {
            v = JmxSupport.getPlatformMBeanServer() == null;
        }
        catch (NoClassDefFoundError err) {
            v = true;
        }
        MANAGEMENT_UNAVAILABLE = v;
    }
}

