/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.impl.xmlConfiguration;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class BeanPropertyMutator {
    private static final String SETTER_PREFIX = "set";
    private final Map<String, Method> settersLookupMap;

    public BeanPropertyMutator(Class<?> _class) {
        this.settersLookupMap = BeanPropertyMutator.generateSetterLookupMap(_class);
    }

    public Class<?> getType(String _propertyName) {
        Method m3 = this.settersLookupMap.get(_propertyName);
        if (m3 == null) {
            return null;
        }
        return m3.getParameterTypes()[0];
    }

    public void mutate(Object _target, String _propertyName, Object _value) throws IllegalAccessException, InvocationTargetException {
        Method m3 = this.settersLookupMap.get(_propertyName);
        m3.invoke(_target, _value);
    }

    private static boolean preferCacheTypeAndNotClass(Class<?> c) {
        return !Class.class.equals(c);
    }

    static Map<String, Method> generateSetterLookupMap(Class<?> c) {
        HashMap<String, Method> map = new HashMap<String, Method>();
        for (Method m3 : c.getMethods()) {
            String _propertyName;
            Method m0;
            if (!m3.getName().startsWith(SETTER_PREFIX) || m3.getReturnType() != Void.TYPE || m3.getParameterTypes().length != 1 || !BeanPropertyMutator.preferCacheTypeAndNotClass(m3.getParameterTypes()[0]) || (m0 = map.put(_propertyName = BeanPropertyMutator.generatePropertyNameFromSetter(m3.getName()), m3)) == null) continue;
            throw new IllegalArgumentException("Ambiguous setter for property '" + _propertyName + "' in class '" + c.getSimpleName() + "'");
        }
        return map;
    }

    static String generatePropertyNameFromSetter(String s2) {
        return BeanPropertyMutator.changeFirstCharToLowerCase(s2.substring(SETTER_PREFIX.length()));
    }

    static String changeFirstCharToLowerCase(String v) {
        return Character.toLowerCase(v.charAt(0)) + v.substring(1);
    }
}

