/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.impl.xmlConfiguration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cache2k.impl.xmlConfiguration.ConfigurationTokenizer;
import org.cache2k.impl.xmlConfiguration.SourceLocation;

public class ParsedConfiguration
implements SourceLocation {
    private String source;
    private int lineNumber;
    private String name;
    private String type;
    private String container;
    private String propertyContext;
    private Map<String, ConfigurationTokenizer.Property> properties = new HashMap<String, ConfigurationTokenizer.Property>();
    private List<ParsedConfiguration> sections = new ArrayList<ParsedConfiguration>();

    public ParsedConfiguration(String _source, int _lineNumber) {
        this.lineNumber = _lineNumber;
        this.source = _source;
    }

    @Override
    public String getSource() {
        return this.source;
    }

    @Override
    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getContainer() {
        return this.container;
    }

    public void setContainer(String _container) {
        this.container = _container;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String _name) {
        this.name = _name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String _type) {
        this.type = _type;
    }

    public String getPropertyContext() {
        return this.propertyContext;
    }

    public void setPropertyContext(String _propertyContext) {
        this.propertyContext = _propertyContext;
    }

    public Map<String, ConfigurationTokenizer.Property> getPropertyMap() {
        return this.properties;
    }

    public List<ParsedConfiguration> getSections() {
        return this.sections;
    }

    public void addProperty(ConfigurationTokenizer.Property p) {
        if ("name".equals(p.getName())) {
            this.name = p.getValue();
        }
        if ("type".equals(p.getName())) {
            this.type = p.getValue();
        }
        this.properties.put(p.getName(), p);
    }

    public void addSection(ParsedConfiguration c) {
        this.sections.add(c);
    }

    public ParsedConfiguration getSection(String _name) {
        for (ParsedConfiguration c : this.sections) {
            if (!_name.equals(c.getName())) continue;
            return c;
        }
        return null;
    }

    public String getStringPropertyByPath(String s2) {
        ConfigurationTokenizer.Property p = this.getPropertyByPath(s2);
        if (p == null) {
            return null;
        }
        return p.getValue();
    }

    public ConfigurationTokenizer.Property getPropertyByPath(String s2) {
        int idx = 0;
        String[] _components = s2.split("\\.");
        ParsedConfiguration cfg = this;
        while (idx < _components.length - 1) {
            if ((cfg = cfg.getSection(_components[idx++])) != null) continue;
            return null;
        }
        ConfigurationTokenizer.Property p = cfg.getPropertyMap().get(_components[idx]);
        if (p == null) {
            return null;
        }
        return p;
    }

    public String toString() {
        return "ParsedSection{container=" + this.container + ", name=" + this.name + ", type=" + this.type;
    }
}

