/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.impl.xmlConfiguration;

import java.util.HashMap;
import java.util.Map;
import org.cache2k.impl.xmlConfiguration.ConfigurationException;
import org.cache2k.impl.xmlConfiguration.ConfigurationTokenizer;
import org.cache2k.impl.xmlConfiguration.ParsedConfiguration;
import org.cache2k.impl.xmlConfiguration.VariableExpander;

public class StandardVariableExpander
implements VariableExpander {
    private Map<String, VariableExpander.ValueAccessor> scope2resolver = new HashMap<String, VariableExpander.ValueAccessor>();
    private static final String PROPERTIES = "PROPERTIES";

    public StandardVariableExpander() {
        this.scope2resolver.put("env", new VariableExpander.ValueAccessor(){

            @Override
            public String get(VariableExpander.ExpanderContext ctx, String _variable) {
                return System.getenv(_variable);
            }
        });
        this.scope2resolver.put("sys", new VariableExpander.ValueAccessor(){

            @Override
            public String get(VariableExpander.ExpanderContext ctx, String _variable) {
                return System.getProperty(_variable);
            }
        });
        this.scope2resolver.put("top", new VariableExpander.ValueAccessor(){

            @Override
            public String get(VariableExpander.ExpanderContext ctx, String _variable) {
                ConfigurationTokenizer.Property p = ctx.getTopLevelConfiguration().getPropertyByPath(_variable);
                return StandardVariableExpander.this.checkAndReturnValue(p);
            }
        });
        this.scope2resolver.put("", new VariableExpander.ValueAccessor(){

            @Override
            public String get(VariableExpander.ExpanderContext ctx, String _variable) {
                ConfigurationTokenizer.Property p = ctx.getCurrentConfiguration().getPropertyByPath(_variable);
                return StandardVariableExpander.this.checkAndReturnValue(p);
            }
        });
        this.scope2resolver.put(PROPERTIES, new VariableExpander.ValueAccessor(){

            @Override
            public String get(VariableExpander.ExpanderContext ctx, String _variable) {
                ParsedConfiguration pc = ctx.getTopLevelConfiguration().getSection("properties");
                if (pc == null) {
                    return null;
                }
                ConfigurationTokenizer.Property p = pc.getPropertyMap().get(_variable);
                return StandardVariableExpander.this.checkAndReturnValue(p);
            }
        });
    }

    @Override
    public void expand(ParsedConfiguration cfg) {
        new Process(cfg, new HashMap<String, VariableExpander.ValueAccessor>(this.scope2resolver)).expand();
    }

    private String checkAndReturnValue(ConfigurationTokenizer.Property p) {
        if (p == null) {
            return null;
        }
        if (!p.isExpanded()) {
            throw new VariableExpander.NeedsExpansion();
        }
        return p.getValue();
    }

    private static class Process
    implements VariableExpander.ExpanderContext {
        private final Map<String, VariableExpander.ValueAccessor> scope2resolver;
        private final ParsedConfiguration top;
        private ParsedConfiguration current;
        private int forwardReference = 0;
        private ConfigurationTokenizer.Property lastTroublemaker;

        Process(ParsedConfiguration _top, Map<String, VariableExpander.ValueAccessor> _scope2resolver) {
            this.top = _top;
            this.scope2resolver = _scope2resolver;
        }

        private void expand() {
            do {
                int lastCounter = this.forwardReference;
                this.forwardReference = 0;
                this.recurse(this.top);
                if (lastCounter <= 0 || lastCounter != this.forwardReference) continue;
                throw new ConfigurationException("Cyclic reference", this.lastTroublemaker);
            } while (this.forwardReference > 0);
        }

        private void recurse(ParsedConfiguration cfg) {
            this.current = cfg;
            for (ConfigurationTokenizer.Property p : cfg.getPropertyMap().values()) {
                if (p.isExpanded()) continue;
                String v0 = p.getValue();
                try {
                    String v = this.expand(v0);
                    if (v0 != v) {
                        p.setValue(v);
                    }
                    p.setExpanded(true);
                }
                catch (VariableExpander.NeedsExpansion ex) {
                    ++this.forwardReference;
                    this.lastTroublemaker = p;
                }
            }
            for (ParsedConfiguration c2 : cfg.getSections()) {
                String _context = c2.getPropertyContext();
                VariableExpander.ValueAccessor _savedAccessor = null;
                if (_context != null) {
                    _savedAccessor = this.scope2resolver.get(_context);
                    final ParsedConfiguration _localScope = c2;
                    this.scope2resolver.put(_context, new VariableExpander.ValueAccessor(){

                        @Override
                        public String get(VariableExpander.ExpanderContext ctx, String _variable) {
                            return _localScope.getStringPropertyByPath(_variable);
                        }
                    });
                }
                this.recurse(c2);
                if (_savedAccessor == null) continue;
                this.scope2resolver.put(_context, _savedAccessor);
            }
        }

        @Override
        public ParsedConfiguration getCurrentConfiguration() {
            return this.current;
        }

        @Override
        public ParsedConfiguration getTopLevelConfiguration() {
            return this.top;
        }

        private String expand(String s2) {
            int idx = 0;
            while (true) {
                int _endIdx;
                block9: {
                    String _substitutionString;
                    block10: {
                        String _scope;
                        if ((idx = s2.indexOf("${", idx)) < 0) {
                            return s2;
                        }
                        _endIdx = s2.indexOf(125, idx);
                        if (_endIdx < 0) {
                            return s2;
                        }
                        int _scopeIdx = s2.indexOf(46, idx);
                        if (_scopeIdx >= 0) {
                            _scope = s2.substring(idx + 2, _scopeIdx);
                        } else {
                            _scope = StandardVariableExpander.PROPERTIES;
                            _scopeIdx = idx + 1;
                        }
                        int _defaultIdx = s2.indexOf(":-", idx);
                        int _varEndIdx = _endIdx;
                        String _defaultValue = null;
                        if (_defaultIdx >= 0 && _defaultIdx < _endIdx) {
                            _defaultValue = s2.substring(_defaultIdx + 2, _endIdx);
                            _varEndIdx = _defaultIdx;
                        }
                        String _varName = s2.substring(_scopeIdx + 1, _varEndIdx);
                        VariableExpander.ValueAccessor r = this.scope2resolver.get(_scope);
                        if (r == null) break block9;
                        _substitutionString = r.get(this, _varName);
                        if (_substitutionString != null) break block10;
                        if (_defaultValue == null) break block9;
                        _substitutionString = _defaultValue;
                    }
                    s2 = s2.substring(0, idx) + _substitutionString + s2.substring(_endIdx + 1);
                    _endIdx = idx + _substitutionString.length();
                }
                idx = _endIdx;
            }
        }
    }
}

