/*
 * Decompiled with CFR 0.152.
 */
package com.performant.coremod.config;

import com.performant.coremod.config.AbstractConfiguration;
import net.minecraftforge.common.ForgeConfigSpec;

public class CommonConfiguration
extends AbstractConfiguration {
    public final ForgeConfigSpec.IntValue goalSelectorTickRate;
    public final ForgeConfigSpec.BooleanValue optimizeTempt;
    public final ForgeConfigSpec.BooleanValue optimizeAvoid;
    public final ForgeConfigSpec.BooleanValue optimizeHurtByTarget;
    public final ForgeConfigSpec.BooleanValue optimizePanic;
    public final ForgeConfigSpec.BooleanValue optimizeBreed;
    public final ForgeConfigSpec.BooleanValue slowFindShelter;

    protected CommonConfiguration(ForgeConfigSpec.Builder builder) {
        this.createCategory(builder, "Entity");
        builder.comment("Sets the tick, ticks happen 20 times each sec, interval in which non-running AI tasks are rechecked. Vanilla default is 1, this mods suggested default is 4").push("Entity");
        this.goalSelectorTickRate = CommonConfiguration.defineInteger(builder, "goalselectorrate", 4, 1, 500);
        builder.comment("Whether to use a slower updated AI tempt goal, tempt is used e.g. for luring sheep with wheat. default = true").push("Entity");
        this.optimizeTempt = CommonConfiguration.defineBoolean(builder, "optimizeTempt", true);
        builder.comment("Whether to use a slower updated AI avoid entity goal, avoid is used e.g. for villagers avoiding zombies so it constantly searches for mobs in the area. default = true").push("Entity");
        this.optimizeAvoid = CommonConfiguration.defineBoolean(builder, "optimizeAvoid", true);
        builder.comment("Whether to use a modified/fixed HurtByTarget goal which is used to call other entities for help. default = true").push("Entity");
        this.optimizeHurtByTarget = CommonConfiguration.defineBoolean(builder, "optimizeHurtByTarget", true);
        builder.comment("Whether to use a slower updated AI Panic entity goal, panic is used for chickens/other animals running away e.g. on fire. default = true").push("Entity");
        this.optimizePanic = CommonConfiguration.defineBoolean(builder, "optimizePanic", true);
        builder.comment("Whether to use a slower updated AI Breed entity goal, breed is used for searching nearby similar animals and doesnt have to be checked that often. default = true").push("Entity");
        this.optimizeBreed = CommonConfiguration.defineBoolean(builder, "optimizeBreed", true);
        builder.comment("Whether to use a slower updated AI Fox find shelter goal, which causes too much load. default = true").push("Entity");
        this.slowFindShelter = CommonConfiguration.defineBoolean(builder, "slowFindShelter", true);
        this.finishCategory(builder);
    }
}

