/*
 * Decompiled with CFR 0.152.
 */
package com.performant.coremod.config;

import java.util.List;
import java.util.function.Predicate;
import net.minecraftforge.common.ForgeConfigSpec;

public abstract class AbstractConfiguration {
    protected void createCategory(ForgeConfigSpec.Builder builder, String key) {
        builder.comment(key).push(key);
    }

    protected void swapToCategory(ForgeConfigSpec.Builder builder, String key) {
        this.finishCategory(builder);
        this.createCategory(builder, key);
    }

    protected void finishCategory(ForgeConfigSpec.Builder builder) {
        builder.pop();
    }

    private static String nameTKey(String key) {
        return "performant.config." + key;
    }

    private static String commentTKey(String key) {
        return AbstractConfiguration.nameTKey(key) + ".comment";
    }

    private static ForgeConfigSpec.Builder buildBase(ForgeConfigSpec.Builder builder, String key) {
        return builder.comment(key).translation(AbstractConfiguration.nameTKey(key));
    }

    protected static ForgeConfigSpec.BooleanValue defineBoolean(ForgeConfigSpec.Builder builder, String key, boolean defaultValue) {
        return AbstractConfiguration.buildBase(builder, key).define(key, defaultValue);
    }

    protected static ForgeConfigSpec.IntValue defineInteger(ForgeConfigSpec.Builder builder, String key, int defaultValue) {
        return AbstractConfiguration.defineInteger(builder, key, defaultValue, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    protected static ForgeConfigSpec.IntValue defineInteger(ForgeConfigSpec.Builder builder, String key, int defaultValue, int min, int max) {
        return AbstractConfiguration.buildBase(builder, key).defineInRange(key, defaultValue, min, max);
    }

    protected static ForgeConfigSpec.LongValue defineLong(ForgeConfigSpec.Builder builder, String key, long defaultValue) {
        return AbstractConfiguration.defineLong(builder, key, defaultValue, Long.MIN_VALUE, Long.MAX_VALUE);
    }

    protected static ForgeConfigSpec.LongValue defineLong(ForgeConfigSpec.Builder builder, String key, long defaultValue, long min, long max) {
        return AbstractConfiguration.buildBase(builder, key).defineInRange(key, defaultValue, min, max);
    }

    protected static ForgeConfigSpec.DoubleValue defineDouble(ForgeConfigSpec.Builder builder, String key, double defaultValue) {
        return AbstractConfiguration.defineDouble(builder, key, defaultValue, Double.MIN_VALUE, Double.MAX_VALUE);
    }

    protected static ForgeConfigSpec.DoubleValue defineDouble(ForgeConfigSpec.Builder builder, String key, double defaultValue, double min, double max) {
        return AbstractConfiguration.buildBase(builder, key).defineInRange(key, defaultValue, min, max);
    }

    protected static <T> ForgeConfigSpec.ConfigValue<List<? extends T>> defineList(ForgeConfigSpec.Builder builder, String key, List<? extends T> defaultValue, Predicate<Object> elementValidator) {
        return AbstractConfiguration.buildBase(builder, key).defineList(key, defaultValue, elementValidator);
    }

    protected static <V extends Enum<V>> ForgeConfigSpec.EnumValue<V> defineEnum(ForgeConfigSpec.Builder builder, String key, V defaultValue) {
        return AbstractConfiguration.buildBase(builder, key).defineEnum(key, defaultValue);
    }
}

