/*
 * Decompiled with CFR 0.152.
 */
package vibrantjourneys;

import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import vibrantjourneys.ICommonProxy;
import vibrantjourneys.init.PVJBiomes;
import vibrantjourneys.init.PVJBlocks;
import vibrantjourneys.init.PVJEntities;
import vibrantjourneys.init.PVJItems;
import vibrantjourneys.init.PVJRecipes;
import vibrantjourneys.init.PVJRegistryEvents;
import vibrantjourneys.init.PVJTileEntities;
import vibrantjourneys.init.PVJWorldGen;
import vibrantjourneys.util.BiomeReference;
import vibrantjourneys.util.GuiHandler;
import vibrantjourneys.util.PVJConfig;
import vibrantjourneys.util.PVJEvents;
import vibrantjourneys.util.PVJOreDictionary;
import vibrantjourneys.util.PVJTerrainGenEvents;
import vibrantjourneys.util.Reference;

@Mod(modid="pvj", name="Project: Vibrant Journeys", version="1.3.2", dependencies="after:*", acceptedMinecraftVersions="[1.12.2]")
public class ProjectVibrantJourneys {
    @Mod.Instance(value="pvj")
    public static ProjectVibrantJourneys instance;
    @SidedProxy(clientSide="vibrantjourneys.ClientProxy", serverSide="vibrantjourneys.ServerProxy")
    public static ICommonProxy proxy;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        if (Loader.isModLoaded((String)"biomesoplenty")) {
            System.out.println("Project: Vibrant Journeys has detected that you also have Biomes O' Plenty installed!");
            Reference.isBOPLoaded = true;
        }
        PVJEntities.initEntities();
        PVJItems.initItems();
        PVJBlocks.initBlocks();
        PVJBiomes.initBiomes();
        PVJTileEntities.initTileEntities();
        MinecraftForge.EVENT_BUS.register((Object)new PVJRegistryEvents());
        MinecraftForge.EVENT_BUS.register((Object)new PVJConfig.ConfigEventHandler());
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.registerTESRs();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new GuiHandler());
        PVJOreDictionary.setValues();
        PVJRecipes.initRecipes();
        BiomeReference.loadAllBiomeReferences();
        PVJWorldGen.initWorldGen();
        PVJEntities.addSpawns();
        if (PVJConfig.misc.restrictSquidsToOceans) {
            EntityRegistry.removeSpawn(EntitySquid.class, (EnumCreatureType)EnumCreatureType.WATER_CREATURE, (Biome[])BiomeReference.getValidBiomes(BiomeReference.FRESHWATER_BIOMES));
        }
        proxy.registerBlockColors();
        MinecraftForge.EVENT_BUS.register((Object)new PVJEvents());
        MinecraftForge.TERRAIN_GEN_BUS.register((Object)new PVJTerrainGenEvents());
    }
}

