/*
 * Decompiled with CFR 0.152.
 */
package vibrantjourneys.biomes;

import java.util.Random;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.entity.passive.EntityRabbit;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenTaiga1;
import net.minecraft.world.gen.feature.WorldGenTaiga2;
import net.minecraft.world.gen.feature.WorldGenTallGrass;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vibrantjourneys.util.PVJConfig;
import vibrantjourneys.worldgen.WorldGenFirTree;
import vibrantjourneys.worldgen.WorldGenPineTree;

public class BiomeBorealForest
extends Biome {
    private static final WorldGenPineTree PINE = new WorldGenPineTree(false);
    private static final WorldGenFirTree FIR = new WorldGenFirTree(false);
    private static final WorldGenTaiga1 TAIGA1 = new WorldGenTaiga1();
    private static final WorldGenTaiga2 TAIGA2 = new WorldGenTaiga2(false);

    public BiomeBorealForest(Biome.BiomeProperties properties) {
        super(properties);
        this.field_76762_K.add(new Biome.SpawnListEntry(EntityWolf.class, 8, 4, 4));
        this.field_76762_K.add(new Biome.SpawnListEntry(EntityRabbit.class, 4, 2, 3));
        this.field_76760_I.field_76832_z = 9;
        this.field_76760_I.field_76803_B = 11;
        this.field_76760_I.field_76802_A = 2;
        this.field_76760_I.field_76798_D = 5;
    }

    public WorldGenAbstractTree func_150567_a(Random rand) {
        int num = rand.nextInt(100);
        if (num > 45 && rand.nextInt(PVJConfig.worldgen.firDensity) < PVJConfig.worldgen.firDensity - 2) {
            return FIR;
        }
        if (num > 10 && rand.nextInt(PVJConfig.worldgen.pineDensity) < PVJConfig.worldgen.pineDensity - 2) {
            return PINE;
        }
        return rand.nextBoolean() ? TAIGA2 : TAIGA1;
    }

    public WorldGenerator func_76730_b(Random rand) {
        return rand.nextInt(5) > 0 ? new WorldGenTallGrass(BlockTallGrass.EnumType.FERN) : new WorldGenTallGrass(BlockTallGrass.EnumType.GRASS);
    }

    public void func_180624_a(World worldIn, Random rand, BlockPos pos) {
        field_180280_ag.func_180710_a(BlockDoublePlant.EnumPlantType.FERN);
        if (TerrainGen.decorate((World)worldIn, (Random)rand, (ChunkPos)new ChunkPos(pos), (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.FLOWERS)) {
            for (int i1 = 0; i1 < 7; ++i1) {
                int j1 = rand.nextInt(16) + 8;
                int k1 = rand.nextInt(16) + 8;
                int l1 = rand.nextInt(worldIn.func_175645_m(pos.func_177982_a(j1, 0, k1)).func_177956_o() + 32);
                field_180280_ag.func_180709_b(worldIn, rand, pos.func_177982_a(j1, l1, k1));
            }
        }
        super.func_180624_a(worldIn, rand, pos);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_180627_b(BlockPos pos) {
        return 39245;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_180625_c(BlockPos pos) {
        return 39245;
    }
}

