/*
 * Decompiled with CFR 0.152.
 */
package vibrantjourneys.blocks;

import com.google.common.collect.ImmutableList;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import vibrantjourneys.util.IPropertyHelper;

public class BlockGroundCover
extends Block
implements IPropertyHelper {
    public static final PropertyInteger MODEL = PropertyInteger.func_177719_a((String)"model", (int)0, (int)4);

    public BlockGroundCover(Material material) {
        super(material);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)MODEL, (Comparable)Integer.valueOf(0)));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.125, 1.0);
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return null;
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return true;
    }

    public boolean func_176214_u(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return super.func_176196_c(worldIn, pos) ? this.canBlockStay(worldIn, pos) : false;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!this.canBlockStay(worldIn, pos)) {
            worldIn.func_175698_g(pos);
        }
    }

    private boolean canBlockStay(World world, BlockPos pos) {
        return world.isSideSolid(pos.func_177977_b(), EnumFacing.UP);
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean func_185481_k(IBlockState state) {
        return false;
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        if (!world.field_72995_K) {
            int meta = new Random().nextInt(5);
            world.func_175656_a(pos, this.func_176203_a(meta));
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        if (player.func_70093_af()) {
            ItemStack stack = new ItemStack((Block)this, 1, 0);
            InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)stack);
            world.func_175698_g(pos);
        } else if (player.func_184812_l_()) {
            int meta = this.func_176201_c(state);
            meta = meta != 4 ? ++meta : 0;
            world.func_175656_a(pos, this.func_176203_a(meta));
        }
        return true;
    }

    public boolean canHarvestBlock(IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return true;
    }

    public boolean func_176200_f(IBlockAccess worldIn, BlockPos pos) {
        return true;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Items.field_190931_a;
    }

    public int func_180651_a(IBlockState state) {
        return 0;
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack((Block)this);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)MODEL, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)MODEL);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{MODEL});
    }

    @Override
    public ImmutableList<IBlockState> getProperties() {
        return this.field_176227_L.func_177619_a();
    }
}

