/*
 * Decompiled with CFR 0.152.
 */
package vibrantjourneys.blocks;

import com.google.common.collect.ImmutableList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockWall;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vibrantjourneys.util.IPropertyHelper;

public class BlockLantern
extends Block
implements IPropertyHelper {
    public Type type;
    public static final PropertyBool HANGING = PropertyBool.func_177716_a((String)"hanging");

    public BlockLantern(Type type) {
        super(Material.field_151594_q);
        this.func_149672_a(type == Type.PAPER ? SoundType.field_185850_c : SoundType.field_185851_d);
        this.func_149715_a(0.7f + (type == Type.LAVA ? 0.07f : 0.0f));
        this.type = type;
        this.func_149711_c(0.1f);
        this.func_149752_b(0.1f);
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a((IProperty)HANGING, (Comparable)Boolean.valueOf(false)));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        if (this.type != Type.PAPER) {
            if (((Boolean)state.func_177229_b((IProperty)HANGING)).booleanValue()) {
                return new AxisAlignedBB(0.3125, 0.3125, 0.3125, 0.6875, 1.0, 0.6875);
            }
            return new AxisAlignedBB(0.3125, 0.0, 0.3125, 0.6875, 0.6875, 0.6875);
        }
        if (((Boolean)state.func_177229_b((IProperty)HANGING)).booleanValue()) {
            return new AxisAlignedBB(0.1875, 0.125, 0.1875, 0.8125, 1.0, 0.8125);
        }
        return new AxisAlignedBB(0.1875, 0.0, 0.1875, 0.8125, 0.625, 0.8125);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World worldIn, BlockPos pos, Random rand) {
        double y;
        double x = (double)pos.func_177958_n() + 0.5;
        double z = (double)pos.func_177952_p() + 0.5;
        switch (this.type) {
            default: {
                y = (double)pos.func_177956_o() + 0.16;
                break;
            }
            case CANDLE: {
                y = (double)pos.func_177956_o() + 0.55;
                break;
            }
            case LAVA: 
            case PAPER: {
                y = 0.0;
            }
        }
        if (((Boolean)state.func_177229_b((IProperty)HANGING)).booleanValue()) {
            y += 0.33;
        }
        if (this.type != Type.LAVA && this.type != Type.PAPER) {
            worldIn.func_175688_a(EnumParticleTypes.FLAME, x, y, z, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        return this.canPlaceLantern(world, pos);
    }

    private boolean canPlaceLantern(World world, BlockPos pos) {
        if (world.isSideSolid(pos.func_177984_a(), EnumFacing.DOWN) || world.isSideSolid(pos.func_177977_b(), EnumFacing.UP)) {
            return true;
        }
        if (world.func_180495_p(pos.func_177984_a()).func_177230_c() instanceof BlockFence || world.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof BlockFence) {
            return true;
        }
        return world.func_180495_p(pos.func_177984_a()).func_177230_c() instanceof BlockWall || world.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof BlockWall;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!this.canBlockStay(world, pos)) {
            this.func_176226_b(world, pos, state, 0);
            world.func_175698_g(pos);
        }
    }

    private boolean canBlockStay(World world, BlockPos pos) {
        return this.canPlaceLantern(world, pos);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        if (player.func_70093_af()) {
            if (((Boolean)state.func_177229_b((IProperty)HANGING)).booleanValue() && (world.isSideSolid(pos.func_177977_b(), EnumFacing.UP) || world.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof BlockFence || world.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof BlockWall)) {
                world.func_175656_a(pos, this.func_176223_P().func_177226_a((IProperty)HANGING, (Comparable)Boolean.valueOf(false)));
            } else if (!((Boolean)state.func_177229_b((IProperty)HANGING)).booleanValue() && (world.isSideSolid(pos.func_177984_a(), EnumFacing.DOWN) || world.func_180495_p(pos.func_177984_a()).func_177230_c() instanceof BlockFence || world.func_180495_p(pos.func_177984_a()).func_177230_c() instanceof BlockWall)) {
                world.func_175656_a(pos, this.func_176223_P().func_177226_a((IProperty)HANGING, (Comparable)Boolean.valueOf(true)));
            }
        }
        return true;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        if (world.func_180495_p(pos.func_177984_a()).func_177230_c() instanceof BlockFence || world.func_180495_p(pos.func_177984_a()).func_177230_c() instanceof BlockWall || world.isSideSolid(pos.func_177984_a(), EnumFacing.DOWN)) {
            return this.func_176223_P().func_177226_a((IProperty)HANGING, (Comparable)Boolean.valueOf(true));
        }
        return this.func_176223_P();
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return true;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{HANGING});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)HANGING, (Comparable)Boolean.valueOf(meta != 0));
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)HANGING) != false ? 1 : 0;
    }

    public int func_180651_a(IBlockState state) {
        return 0;
    }

    @Override
    public ImmutableList<IBlockState> getProperties() {
        return this.func_176194_O().func_177619_a();
    }

    public static enum Type {
        NORMAL,
        CANDLE,
        LAVA,
        PAPER;

    }
}

