/*
 * Decompiled with CFR 0.152.
 */
package vibrantjourneys.init;

import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.DungeonHooks;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import vibrantjourneys.entities.item.EntityCoconut;
import vibrantjourneys.entities.item.EntityPVJBoat;
import vibrantjourneys.entities.monster.EntityGoon;
import vibrantjourneys.entities.monster.EntityIceCube;
import vibrantjourneys.entities.monster.EntityShade;
import vibrantjourneys.entities.monster.EntitySkeletalKnight;
import vibrantjourneys.entities.neutral.EntityGhost;
import vibrantjourneys.entities.neutral.EntityGrizzlyBear;
import vibrantjourneys.entities.passive.EntityFirefly;
import vibrantjourneys.entities.passive.EntityFly;
import vibrantjourneys.entities.passive.EntitySmallSpider;
import vibrantjourneys.entities.passive.EntitySnail;
import vibrantjourneys.util.BiomeReference;
import vibrantjourneys.util.PVJConfig;

public class PVJEntities {
    public static int id = 1;
    public static final ArrayList<EntityEntry> ENTITIES = new ArrayList();

    public static void initEntities() {
        PVJEntities.registerEntityWithEgg("pvj_snail", EntitySnail.class, 64, 7161149, 6781788);
        PVJEntities.registerEntityWithEgg("pvj_fly", EntityFly.class, 64, 0x669999, 0x737373);
        PVJEntities.registerEntityWithEgg("pvj_firefly", EntityFirefly.class, 64, 4146493, 15261757);
        PVJEntities.registerEntityWithEgg("pvj_small_spider", EntitySmallSpider.class, 64, 6656, 0x4D0000);
        PVJEntities.registerEntityWithEgg("pvj_grizzly_bear", EntityGrizzlyBear.class, 64, 8013099, 3940627);
        PVJEntities.registerEntityWithEgg("pvj_ghost", EntityGhost.class, 64, 0xB3B3B3, 0x404040);
        PVJEntities.registerEntityWithEgg("pvj_shade", EntityShade.class, 64, 0x333333, 0x595959);
        PVJEntities.registerEntityWithEgg("pvj_icecube", EntityIceCube.class, 64, 6742271, 0xCCF5FF);
        PVJEntities.registerEntityWithEgg("pvj_skeletal_knight", EntitySkeletalKnight.class, 64, 0xA6A6A6, 0x808080);
        PVJEntities.registerEntityWithEgg("pvj_goon", EntityGoon.class, 64, 0xA6A6A6, 0x808080);
        PVJEntities.registerEntity("pvj_boat", EntityPVJBoat.class, 64);
        PVJEntities.registerEntity("pvj_coconut", EntityCoconut.class, 64);
    }

    private static <T extends Entity> void registerEntity(String name, Class<T> entityClass, int trackingRange) {
        ResourceLocation entityResource = new ResourceLocation("pvj", name);
        EntityEntry entity = EntityEntryBuilder.create().entity(entityClass).id(entityResource, id++).name(name).tracker(trackingRange, 3, true).build();
        ENTITIES.add(entity);
    }

    private static <T extends Entity> void registerEntityWithEgg(String name, Class<T> entityClass, int trackingRange, int eggPrimary, int eggSecondary) {
        ResourceLocation entityResource = new ResourceLocation("pvj", name);
        EntityEntry entity = EntityEntryBuilder.create().entity(entityClass).id(entityResource, id++).name(name).tracker(trackingRange, 3, true).egg(eggPrimary, eggSecondary).build();
        ENTITIES.add(entity);
    }

    public static void addSpawns() {
        if (PVJConfig.master.enablePassiveMobs) {
            if (PVJConfig.entities.snailSpawnWeight > 0) {
                EntityRegistry.addSpawn(EntitySnail.class, (int)PVJConfig.entities.snailSpawnWeight, (int)2, (int)4, (EnumCreatureType)EnumCreatureType.AMBIENT, (Biome[])BiomeReference.getValidBiomes(BiomeReference.FRESHWATER_BIOMES));
            }
            if (PVJConfig.entities.flySpawnWeight > 0) {
                EntityRegistry.addSpawn(EntityFly.class, (int)PVJConfig.entities.flySpawnWeight, (int)3, (int)4, (EnumCreatureType)EnumCreatureType.AMBIENT, (Biome[])BiomeReference.getValidBiomes(BiomeReference.OVERWORLD_BIOMES));
            }
            if (PVJConfig.entities.flySwampSpawnWeight > 0) {
                EntityRegistry.addSpawn(EntityFly.class, (int)PVJConfig.entities.flySwampSpawnWeight, (int)4, (int)5, (EnumCreatureType)EnumCreatureType.AMBIENT, (Biome[])BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SWAMP).toArray(new Biome[0]));
            }
            if (PVJConfig.entities.fireflySpawnWeight > 0) {
                EntityRegistry.addSpawn(EntityFirefly.class, (int)PVJConfig.entities.fireflySpawnWeight, (int)4, (int)9, (EnumCreatureType)EnumCreatureType.AMBIENT, (Biome[])BiomeReference.getValidBiomes(BiomeReference.OVERWORLD_BIOMES));
            }
            if (PVJConfig.entities.spiderSpawnWeight > 0) {
                EntityRegistry.addSpawn(EntitySmallSpider.class, (int)PVJConfig.entities.spiderSpawnWeight, (int)1, (int)6, (EnumCreatureType)EnumCreatureType.AMBIENT, (Biome[])BiomeReference.getValidBiomes(BiomeReference.OVERWORLD_BIOMES));
            }
        }
        if (PVJConfig.master.enableNeutralMobs) {
            if (PVJConfig.entities.ghostSpawnWeight > 0) {
                EntityRegistry.addSpawn(EntityGhost.class, (int)PVJConfig.entities.ghostSpawnWeight, (int)1, (int)4, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])BiomeReference.getValidBiomes(BiomeReference.OVERWORLD_BIOMES));
            }
            if (PVJConfig.entities.grizzlyBearSpawnWeight > 0) {
                EntityRegistry.addSpawn(EntityGrizzlyBear.class, (int)PVJConfig.entities.grizzlyBearSpawnWeight, (int)1, (int)2, (EnumCreatureType)EnumCreatureType.CREATURE, (Biome[])BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.CONIFEROUS).toArray(new Biome[0]));
            }
        }
        if (PVJConfig.master.enableAggressiveMobs) {
            if (PVJConfig.entities.shadeSpawnWeight > 0) {
                EntityRegistry.addSpawn(EntityShade.class, (int)PVJConfig.entities.shadeSpawnWeight, (int)1, (int)3, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])BiomeReference.getValidBiomes(BiomeReference.OVERWORLD_BIOMES));
            }
            if (PVJConfig.entities.skeletalKnightWeight > 0) {
                EntityRegistry.addSpawn(EntitySkeletalKnight.class, (int)PVJConfig.entities.skeletalKnightWeight, (int)1, (int)3, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])BiomeReference.getValidBiomes(BiomeReference.OVERWORLD_BIOMES));
            }
            if (PVJConfig.entities.icecubeSpawnWeight > 0) {
                EntityRegistry.addSpawn(EntityIceCube.class, (int)PVJConfig.entities.icecubeSpawnWeight, (int)2, (int)3, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])BiomeReference.getValidBiomes(BiomeReference.SNOWY_BIOMES));
            }
            if (PVJConfig.entities.goonSpawnWeight > 0) {
                EntityRegistry.addSpawn(EntityGoon.class, (int)PVJConfig.entities.goonSpawnWeight, (int)1, (int)1, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])BiomeReference.getValidBiomes(BiomeReference.OVERWORLD_BIOMES));
            }
        }
        DungeonHooks.addDungeonMob((ResourceLocation)new ResourceLocation("pvj", "pvj_shade"), (int)100);
        DungeonHooks.addDungeonMob((ResourceLocation)new ResourceLocation("pvj", "pvj_skeletal_knight"), (int)100);
    }
}

