/*
 * Decompiled with CFR 0.152.
 */
package vibrantjourneys.init;

import com.google.common.collect.ImmutableList;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import vibrantjourneys.ProjectVibrantJourneys;
import vibrantjourneys.blocks.BlockCeilingLamp;
import vibrantjourneys.blocks.BlockMysticalGrill;
import vibrantjourneys.blocks.BlockPVJDoor;
import vibrantjourneys.blocks.BlockPVJFenceGate;
import vibrantjourneys.init.PVJBlocks;
import vibrantjourneys.init.PVJEntities;
import vibrantjourneys.init.PVJItems;
import vibrantjourneys.init.PVJSounds;
import vibrantjourneys.util.IPropertyHelper;

public class PVJRegistryEvents {
    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        IForgeRegistry registry = event.getRegistry();
        for (Block block : PVJBlocks.BLOCKS) {
            registry.register((IForgeRegistryEntry)block);
        }
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        for (Item item : PVJItems.ITEMS) {
            registry.register((IForgeRegistryEntry)item);
        }
    }

    @SubscribeEvent
    public void registerItemModels(ModelRegistryEvent event) {
        for (Block block : PVJBlocks.BLOCKS) {
            ProjectVibrantJourneys.proxy.registerItemRenderer(Item.func_150898_a((Block)block));
            if (block instanceof IPropertyHelper) {
                IPropertyHelper PVJBlock = (IPropertyHelper)block;
                ImmutableList<IBlockState> properties = PVJBlock.getProperties();
                for (IBlockState state : properties) {
                    int meta = block.func_176201_c(state);
                    ModelResourceLocation resource = new ModelResourceLocation(block.getRegistryName(), "inventory");
                    ProjectVibrantJourneys.proxy.registerItemVariantRenderer(Item.func_150898_a((Block)block), meta, resource);
                }
            }
            if (block instanceof BlockPVJDoor) {
                ProjectVibrantJourneys.proxy.setIgnoredPropertiesForModel(Item.func_150898_a((Block)block), new IProperty[]{BlockPVJDoor.field_176522_N});
            }
            if (!(block instanceof BlockPVJFenceGate)) continue;
            ProjectVibrantJourneys.proxy.setIgnoredPropertiesForModel(Item.func_150898_a((Block)block), new IProperty[]{BlockPVJFenceGate.field_176465_b});
        }
        for (Item item : PVJItems.ITEMS) {
            ProjectVibrantJourneys.proxy.registerItemRenderer(item);
        }
        ProjectVibrantJourneys.proxy.setIgnoredPropertiesForModel(Item.func_150898_a((Block)PVJBlocks.mystical_grill), new IProperty[]{BlockMysticalGrill.IS_COOKING});
        ProjectVibrantJourneys.proxy.setIgnoredPropertiesForModel(Item.func_150898_a((Block)PVJBlocks.ceiling_lamp), new IProperty[]{BlockCeilingLamp.POWERED});
    }

    @SubscribeEvent
    public void registerEntities(RegistryEvent.Register<EntityEntry> event) {
        IForgeRegistry registry = event.getRegistry();
        for (EntityEntry entity : PVJEntities.ENTITIES) {
            registry.register((IForgeRegistryEntry)entity);
        }
        ProjectVibrantJourneys.proxy.registerEntityRenderers();
    }

    @SubscribeEvent
    public void registerSounds(RegistryEvent.Register<SoundEvent> event) {
        IForgeRegistry registry = event.getRegistry();
        for (SoundEvent sound : PVJSounds.SOUND_EVENTS) {
            registry.register((IForgeRegistryEntry)sound);
        }
    }
}

