/*
 * Decompiled with CFR 0.152.
 */
package vibrantjourneys.init;

import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.registry.GameRegistry;
import vibrantjourneys.init.PVJBiomes;
import vibrantjourneys.init.PVJBlocks;
import vibrantjourneys.integration.biomesoplenty.PVJWorldGenerationBOP;
import vibrantjourneys.util.BiomeReference;
import vibrantjourneys.util.PVJConfig;
import vibrantjourneys.util.Reference;
import vibrantjourneys.worldgen.WorldGenBracketFungus;
import vibrantjourneys.worldgen.WorldGenCattail;
import vibrantjourneys.worldgen.WorldGenCobweb;
import vibrantjourneys.worldgen.WorldGenCrackedSand;
import vibrantjourneys.worldgen.WorldGenDesertCaves;
import vibrantjourneys.worldgen.WorldGenFallenLeaves;
import vibrantjourneys.worldgen.WorldGenFallenTree;
import vibrantjourneys.worldgen.WorldGenFloaters;
import vibrantjourneys.worldgen.WorldGenFrozenCaves;
import vibrantjourneys.worldgen.WorldGenGroundCover;
import vibrantjourneys.worldgen.WorldGenMangroveRoot;
import vibrantjourneys.worldgen.WorldGenMangroveTreeSwamp;
import vibrantjourneys.worldgen.WorldGenOvergrownCaves;
import vibrantjourneys.worldgen.WorldGenPVJPlant;
import vibrantjourneys.worldgen.WorldGenPalmTreeBeach;
import vibrantjourneys.worldgen.WorldGenRiverGrass;
import vibrantjourneys.worldgen.WorldGenShortGrass;
import vibrantjourneys.worldgen.WorldGenSmallBush;
import vibrantjourneys.worldgen.WorldGenStalactite;
import vibrantjourneys.worldgen.WorldGenStalagmite;

public class PVJWorldGen {
    public static void initWorldGen() {
        PVJWorldGen.registerWorldGen(new WorldGenCobweb(PVJConfig.worldgen.cobwebDensity));
        PVJWorldGen.registerWorldGen(new WorldGenPalmTreeBeach(PVJConfig.worldgen.palmDensity));
        PVJWorldGen.registerWorldGen(new WorldGenMangroveTreeSwamp(PVJConfig.worldgen.mangroveDensity));
        if (PVJConfig.master.enableCaves) {
            PVJWorldGen.registerWorldGen(new WorldGenStalagmite(PVJBlocks.rock_formation, 0, 70, PVJConfig.worldgen.stalagmiteDensity, BiomeReference.getValidBiomes(BiomeReference.OVERWORLD_BIOMES)));
            PVJWorldGen.registerWorldGen(new WorldGenStalactite(PVJBlocks.rock_formation, 0, 70, PVJConfig.worldgen.stalactiteDensity, BiomeReference.getValidBiomes(BiomeReference.OVERWORLD_BIOMES)));
            if (PVJConfig.worldgen.enableOvergrownCaves) {
                PVJWorldGen.registerWorldGen(new WorldGenOvergrownCaves(BiomeReference.getValidBiomes(BiomeReference.MANGROVE_TREES)));
            }
            if (PVJConfig.worldgen.enableFrozenCaves) {
                PVJWorldGen.registerWorldGen(new WorldGenFrozenCaves(BiomeReference.getValidBiomes(BiomeReference.SNOWY_BIOMES)));
            }
            if (PVJConfig.worldgen.enableSandstoneCaves) {
                PVJWorldGen.registerWorldGen(new WorldGenDesertCaves(BiomeReference.getValidBiomes(BiomeReference.DESERT_BIOMES)));
            }
        }
        if (PVJConfig.master.enableFallenTrees) {
            PVJWorldGen.registerWorldGen(new WorldGenFallenTree(BiomeReference.OAK_LOG, PVJConfig.worldgen.fallenTreeOakDensity, BiomeReference.getValidBiomes(BiomeReference.OAK_TREES)));
            PVJWorldGen.registerWorldGen(new WorldGenFallenTree(BiomeReference.OAK_LOG, PVJConfig.worldgen.fallenTreeOakSparseDensity, BiomeReference.getValidBiomes(BiomeReference.OAK_TREES_SPARSE)));
            PVJWorldGen.registerWorldGen(new WorldGenFallenTree(BiomeReference.BIRCH_LOG, PVJConfig.worldgen.fallenTreeBirchDensity, BiomeReference.getValidBiomes(BiomeReference.BIRCH_TREES)));
            PVJWorldGen.registerWorldGen(new WorldGenFallenTree(BiomeReference.BIRCH_LOG, PVJConfig.worldgen.fallenTreeBirchSparseDensity, BiomeReference.getValidBiomes(BiomeReference.BIRCH_TREES_SPARSE)));
            PVJWorldGen.registerWorldGen(new WorldGenFallenTree(BiomeReference.SPRUCE_LOG, PVJConfig.worldgen.fallenTreeSpruceDensity, BiomeReference.getValidBiomes(BiomeReference.SPRUCE_TREES)));
            PVJWorldGen.registerWorldGen(new WorldGenFallenTree(BiomeReference.SPRUCE_LOG, PVJConfig.worldgen.fallenTreeSpruceSparseDensity, BiomeReference.getValidBiomes(BiomeReference.SPRUCE_TREES_SPARSE)));
            PVJWorldGen.registerWorldGen(new WorldGenFallenTree(BiomeReference.ACACIA_LOG, PVJConfig.worldgen.fallenTreeAcaciaDensity, BiomeReference.getValidBiomes(BiomeReference.ACACIA_TREES)));
            PVJWorldGen.registerWorldGen(new WorldGenFallenTree(PVJBlocks.willow_log, PVJConfig.worldgen.fallenTreeWillowDensity, BiomeReference.getValidBiomes(BiomeReference.WILLOW_TREES)));
            PVJWorldGen.registerWorldGen(new WorldGenFallenTree(PVJBlocks.redwood_log, PVJConfig.worldgen.fallenTreeRedwoodDensity, BiomeReference.getValidBiomes(BiomeReference.REDWOOD_TREES)));
            PVJWorldGen.registerWorldGen(new WorldGenFallenTree(PVJBlocks.fir_log, PVJConfig.worldgen.fallenTreeFirDensity, BiomeReference.getValidBiomes(BiomeReference.FIR_TREES)));
            PVJWorldGen.registerWorldGen(new WorldGenFallenTree(PVJBlocks.pine_log, PVJConfig.worldgen.fallenTreePineDensity, BiomeReference.getValidBiomes(BiomeReference.PINE_TREES)));
            PVJWorldGen.registerWorldGen(new WorldGenFallenTree(PVJBlocks.aspen_log, PVJConfig.worldgen.fallenTreeAspenDensity, BiomeReference.getValidBiomes(BiomeReference.ASPEN_TREES)));
            PVJWorldGen.registerWorldGen(new WorldGenFallenTree(PVJBlocks.maple_log, PVJConfig.worldgen.fallenTreeMapleDensity, BiomeReference.getValidBiomes(BiomeReference.RED_MAPLE_TREES)));
            PVJWorldGen.registerWorldGen(new WorldGenFallenTree(PVJBlocks.baobab_log, PVJConfig.worldgen.fallenTreeBaobabDensity, BiomeReference.getValidBiomes(BiomeReference.BAOBAB_TREES)));
        }
        PVJWorldGen.registerWorldGen(new WorldGenMangroveRoot(PVJConfig.worldgen.mangroveRootDensity, BiomeReference.getValidBiomes(BiomeReference.MANGROVE_TREES)));
        PVJWorldGen.registerWorldGen(new WorldGenSmallBush(PVJConfig.worldgen.bushDensity, BiomeReference.getValidBiomes(BiomeReference.OAK_TREES_SPARSE)));
        if (PVJConfig.master.enableGroundcover) {
            if (PVJConfig.master.enableFallenLeaves) {
                PVJWorldGen.registerWorldGen(new WorldGenFallenLeaves(PVJBlocks.fallenleaves_oak, PVJConfig.worldgen.fallenLeavesOakDensity, BiomeReference.OAK_TREES.toArray(new Biome[0])));
                PVJWorldGen.registerWorldGen(new WorldGenFallenLeaves(PVJBlocks.fallenleaves_oak, PVJConfig.worldgen.fallenLeavesOakSparseDensity, BiomeReference.getValidBiomes(BiomeReference.OAK_TREES_SPARSE)));
                PVJWorldGen.registerWorldGen(new WorldGenFallenLeaves(PVJBlocks.fallenleaves_birch, PVJConfig.worldgen.fallenLeavesBirchDensity, BiomeReference.getValidBiomes(BiomeReference.BIRCH_TREES)));
                PVJWorldGen.registerWorldGen(new WorldGenFallenLeaves(PVJBlocks.fallenleaves_birch, PVJConfig.worldgen.fallenLeavesBirchSparseDensity, BiomeReference.getValidBiomes(BiomeReference.BIRCH_TREES_SPARSE)));
                PVJWorldGen.registerWorldGen(new WorldGenFallenLeaves(PVJBlocks.fallenleaves_spruce, PVJConfig.worldgen.fallenLeavesSpruceDensity, BiomeReference.getValidBiomes(BiomeReference.SPRUCE_TREES)));
                PVJWorldGen.registerWorldGen(new WorldGenFallenLeaves(PVJBlocks.fallenleaves_spruce, PVJConfig.worldgen.fallenLeavesSpruceSparseDensity, BiomeReference.getValidBiomes(BiomeReference.SPRUCE_TREES_SPARSE)));
                PVJWorldGen.registerWorldGen(new WorldGenFallenLeaves(PVJBlocks.fallenleaves_jungle, PVJConfig.worldgen.fallenLeavesJungleDensity, BiomeReference.getValidBiomes(BiomeReference.JUNGLE_TREES)));
                PVJWorldGen.registerWorldGen(new WorldGenFallenLeaves(PVJBlocks.fallenleaves_jungle, PVJConfig.worldgen.fallenLeavesJungleSparseDensity, BiomeReference.getValidBiomes(BiomeReference.JUNGLE_TREES_SPARSE)));
                PVJWorldGen.registerWorldGen(new WorldGenFallenLeaves(PVJBlocks.fallenleaves_darkoak, PVJConfig.worldgen.fallenLeavesDarkOakDensity, BiomeReference.getValidBiomes(BiomeReference.DARKOAK_TREES)));
                PVJWorldGen.registerWorldGen(new WorldGenFallenLeaves(PVJBlocks.fallenleaves_darkoak, PVJConfig.worldgen.fallenLeavesDarkOakSparseDensity, BiomeReference.getValidBiomes(BiomeReference.DARKOAK_TREES_SPARSE)));
                PVJWorldGen.registerWorldGen(new WorldGenFallenLeaves(PVJBlocks.fallenleaves_acacia, PVJConfig.worldgen.fallenLeavesAcaciaDensity, BiomeReference.getValidBiomes(BiomeReference.ACACIA_TREES)));
                PVJWorldGen.registerWorldGen(new WorldGenFallenLeaves(PVJBlocks.fallenleaves_acacia, PVJConfig.worldgen.fallenLeavesAcaciaDensity, BiomeReference.getValidBiomes(BiomeReference.ACACIA_TREES_SPARSE)));
                PVJWorldGen.registerWorldGen(new WorldGenFallenLeaves(PVJBlocks.fallenleaves_willow, PVJConfig.worldgen.fallenLeavesWillowDensity, BiomeReference.getValidBiomes(BiomeReference.WILLOW_TREES)));
                PVJWorldGen.registerWorldGen(new WorldGenFallenLeaves(PVJBlocks.fallenleaves_mangrove, PVJConfig.worldgen.fallenLeavesMangroveDensity, BiomeReference.getValidBiomes(BiomeReference.MANGROVE_TREES)));
                PVJWorldGen.registerWorldGen(new WorldGenFallenLeaves(PVJBlocks.fallenleaves_redwood, PVJConfig.worldgen.fallenLeavesRedwoodDensity, BiomeReference.getValidBiomes(BiomeReference.REDWOOD_TREES)));
                PVJWorldGen.registerWorldGen(new WorldGenFallenLeaves(PVJBlocks.fallenleaves_palm, PVJConfig.worldgen.fallenLeavesPalmDensity, BiomeReference.getValidBiomes(BiomeReference.PALM_TREES)));
                PVJWorldGen.registerWorldGen(new WorldGenFallenLeaves(PVJBlocks.fallenleaves_dead, PVJConfig.worldgen.fallenLeavesDeadDensity, BiomeReference.getValidBiomes(BiomeReference.MESA_BIOMES)));
                PVJWorldGen.registerWorldGen(new WorldGenFallenLeaves(PVJBlocks.fallenleaves_fir, PVJConfig.worldgen.fallenLeavesFirDensity, BiomeReference.getValidBiomes(BiomeReference.FIR_TREES)));
                PVJWorldGen.registerWorldGen(new WorldGenFallenLeaves(PVJBlocks.fallenleaves_pine, PVJConfig.worldgen.fallenLeavesPineDensity, BiomeReference.getValidBiomes(BiomeReference.PINE_TREES)));
                PVJWorldGen.registerWorldGen(new WorldGenFallenLeaves(PVJBlocks.fallenleaves_aspen, PVJConfig.worldgen.fallenLeavesAspenDensity, BiomeReference.getValidBiomes(BiomeReference.ASPEN_TREES)));
                PVJWorldGen.registerWorldGen(new WorldGenFallenLeaves(PVJBlocks.fallenleaves_red_maple, PVJConfig.worldgen.fallenLeavesRedMapleDensity, BiomeReference.getValidBiomes(BiomeReference.RED_MAPLE_TREES)));
                PVJWorldGen.registerWorldGen(new WorldGenFallenLeaves(PVJBlocks.fallenleaves_orange_maple, PVJConfig.worldgen.fallenLeavesOrangeMapleDensity, BiomeReference.getValidBiomes(BiomeReference.ORANGE_MAPLE_TREES)));
                PVJWorldGen.registerWorldGen(new WorldGenFallenLeaves(PVJBlocks.fallenleaves_baobab, PVJConfig.worldgen.fallenLeavesBaobabDensity, BiomeReference.getValidBiomes(BiomeReference.BAOBAB_TREES)));
            }
            if (PVJConfig.master.enableRocks) {
                PVJWorldGen.registerWorldGen(new WorldGenGroundCover(PVJBlocks.stone_rocks, 60, 200, PVJConfig.worldgen.stoneRocksDensity, BiomeReference.getValidBiomes(BiomeReference.OVERWORLD_BIOMES)));
                PVJWorldGen.registerWorldGen(new WorldGenGroundCover(PVJBlocks.cobblestone_rocks, 60, 200, PVJConfig.worldgen.cobblestoneRocksDensity, BiomeReference.getValidBiomes(BiomeReference.OVERWORLD_BIOMES)));
                PVJWorldGen.registerWorldGen(new WorldGenGroundCover(PVJBlocks.mossy_cobblestone_rocks, 40, 200, PVJConfig.worldgen.mossyCobblestoneRocksDensity, BiomeReference.getValidBiomes(BiomeReference.MOSSY_COBBLESTONE_BIOMES)));
                PVJWorldGen.registerWorldGen(new WorldGenGroundCover(PVJBlocks.andesite_rocks, 60, 200, PVJConfig.worldgen.andesiteRocksDensity, BiomeReference.getValidBiomes(BiomeReference.OVERWORLD_BIOMES)));
                PVJWorldGen.registerWorldGen(new WorldGenGroundCover(PVJBlocks.granite_rocks, 60, 200, PVJConfig.worldgen.graniteRocksDensity, BiomeReference.getValidBiomes(BiomeReference.OVERWORLD_BIOMES)));
                PVJWorldGen.registerWorldGen(new WorldGenGroundCover(PVJBlocks.diorite_rocks, 60, 200, PVJConfig.worldgen.dioriteRocksDensity, BiomeReference.getValidBiomes(BiomeReference.OVERWORLD_BIOMES)));
                PVJWorldGen.registerWorldGen(new WorldGenGroundCover(PVJBlocks.sandstone_rocks, 50, 100, PVJConfig.worldgen.sandstoneRocksDensity, BiomeReference.getValidBiomes(BiomeReference.SANDSTONE_BIOMES)));
                PVJWorldGen.registerWorldGen(new WorldGenGroundCover(PVJBlocks.red_sandstone_rocks, 55, 75, PVJConfig.worldgen.redSandstoneRocksDensity, BiomeReference.getValidBiomes(BiomeReference.MESA_BIOMES)));
                PVJWorldGen.registerWorldGen(new WorldGenGroundCover(PVJBlocks.stone_rocks, 1, 60, PVJConfig.worldgen.stoneRocksCaveDensity, BiomeReference.getValidBiomes(BiomeReference.OVERWORLD_BIOMES)));
                PVJWorldGen.registerWorldGen(new WorldGenGroundCover(PVJBlocks.cobblestone_rocks, 1, 60, PVJConfig.worldgen.cobblestoneRocksCaveDensity, BiomeReference.getValidBiomes(BiomeReference.OVERWORLD_BIOMES)));
                PVJWorldGen.registerWorldGen(new WorldGenGroundCover(PVJBlocks.andesite_rocks, 1, 60, PVJConfig.worldgen.andesiteRocksCaveDensity, BiomeReference.getValidBiomes(BiomeReference.OVERWORLD_BIOMES)));
                PVJWorldGen.registerWorldGen(new WorldGenGroundCover(PVJBlocks.granite_rocks, 1, 60, PVJConfig.worldgen.graniteCaveDensity, BiomeReference.getValidBiomes(BiomeReference.OVERWORLD_BIOMES)));
                PVJWorldGen.registerWorldGen(new WorldGenGroundCover(PVJBlocks.diorite_rocks, 1, 60, PVJConfig.worldgen.dioriteRocksCaveDensity, BiomeReference.getValidBiomes(BiomeReference.OVERWORLD_BIOMES)));
            }
            if (PVJConfig.master.enableTwigs) {
                PVJWorldGen.registerWorldGen(new WorldGenGroundCover(PVJBlocks.oak_twigs, 60, 150, PVJConfig.worldgen.oakTwigsDensity, BiomeReference.getValidBiomes(BiomeReference.OAK_TREES)));
                PVJWorldGen.registerWorldGen(new WorldGenGroundCover(PVJBlocks.oak_twigs, 60, 150, PVJConfig.worldgen.oakTwigsSparseDensity, BiomeReference.getValidBiomes(BiomeReference.OAK_TREES_SPARSE)));
                PVJWorldGen.registerWorldGen(new WorldGenGroundCover(PVJBlocks.birch_twigs, 60, 150, PVJConfig.worldgen.birchTwigsDensity, BiomeReference.getValidBiomes(BiomeReference.BIRCH_TREES)));
                PVJWorldGen.registerWorldGen(new WorldGenGroundCover(PVJBlocks.birch_twigs, 60, 150, PVJConfig.worldgen.birchTwigsSparseDensity, BiomeReference.getValidBiomes(BiomeReference.BIRCH_TREES_SPARSE)));
                PVJWorldGen.registerWorldGen(new WorldGenGroundCover(PVJBlocks.spruce_twigs, 60, 150, PVJConfig.worldgen.spruceTwigsDensity, BiomeReference.getValidBiomes(BiomeReference.SPRUCE_TREES)));
                PVJWorldGen.registerWorldGen(new WorldGenGroundCover(PVJBlocks.spruce_twigs, 60, 150, PVJConfig.worldgen.spruceTwigsSparseDensity, BiomeReference.getValidBiomes(BiomeReference.SPRUCE_TREES_SPARSE)));
                PVJWorldGen.registerWorldGen(new WorldGenGroundCover(PVJBlocks.jungle_twigs, 60, 150, PVJConfig.worldgen.jungleTwigsDensity, BiomeReference.getValidBiomes(BiomeReference.JUNGLE_TREES)));
                PVJWorldGen.registerWorldGen(new WorldGenGroundCover(PVJBlocks.acacia_twigs, 60, 150, PVJConfig.worldgen.acaciaTwigsDensity, BiomeReference.getValidBiomes(BiomeReference.ACACIA_TREES)));
                PVJWorldGen.registerWorldGen(new WorldGenGroundCover(PVJBlocks.dark_oak_twigs, 60, 150, PVJConfig.worldgen.darkOakTwigsDensity, BiomeReference.getValidBiomes(BiomeReference.DARKOAK_TREES)));
                PVJWorldGen.registerWorldGen(new WorldGenGroundCover(PVJBlocks.willow_twigs, 60, 150, PVJConfig.worldgen.willowTwigsDensity, BiomeReference.getValidBiomes(BiomeReference.WILLOW_TREES)));
                PVJWorldGen.registerWorldGen(new WorldGenGroundCover(PVJBlocks.mangrove_twigs, 60, 150, PVJConfig.worldgen.mangroveTwigsDensity, BiomeReference.getValidBiomes(BiomeReference.MANGROVE_TREES)));
                PVJWorldGen.registerWorldGen(new WorldGenGroundCover(PVJBlocks.palm_twigs, 60, 150, PVJConfig.worldgen.palmTwigsDensity, BiomeReference.getValidBiomes(BiomeReference.PALM_TREES)));
                PVJWorldGen.registerWorldGen(new WorldGenGroundCover(PVJBlocks.fir_twigs, 60, 150, PVJConfig.worldgen.firTwigsDensity, BiomeReference.getValidBiomes(BiomeReference.FIR_TREES)));
                PVJWorldGen.registerWorldGen(new WorldGenGroundCover(PVJBlocks.pine_twigs, 60, 150, PVJConfig.worldgen.pineTwigsDensity, BiomeReference.getValidBiomes(BiomeReference.PINE_TREES)));
                PVJWorldGen.registerWorldGen(new WorldGenGroundCover(PVJBlocks.aspen_twigs, 60, 150, PVJConfig.worldgen.aspenTwigsDensity, BiomeReference.getValidBiomes(BiomeReference.ASPEN_TREES)));
                PVJWorldGen.registerWorldGen(new WorldGenGroundCover(PVJBlocks.red_maple_twigs, 60, 150, PVJConfig.worldgen.redMapleTwigsDensity, BiomeReference.getValidBiomes(BiomeReference.RED_MAPLE_TREES)));
                PVJWorldGen.registerWorldGen(new WorldGenGroundCover(PVJBlocks.orange_maple_twigs, 60, 150, PVJConfig.worldgen.orangeMapleTwigsDensity, BiomeReference.getValidBiomes(BiomeReference.ORANGE_MAPLE_TREES)));
                PVJWorldGen.registerWorldGen(new WorldGenGroundCover(PVJBlocks.baobab_twigs, 60, 100, PVJConfig.worldgen.baobabTwigsDensity, BiomeReference.getValidBiomes(BiomeReference.BAOBAB_TREES)));
            }
            if (PVJConfig.master.enableBones) {
                PVJWorldGen.registerWorldGen(new WorldGenGroundCover(PVJBlocks.bones, 1, 100, PVJConfig.worldgen.bonesDensity, BiomeReference.getValidBiomes(BiomeReference.OVERWORLD_BIOMES)));
                PVJWorldGen.registerWorldGen(new WorldGenGroundCover(PVJBlocks.bones, 1, 100, PVJConfig.worldgen.bonesDesertDensity, BiomeReference.getValidBiomes(BiomeReference.DESERT_BIOMES)));
                PVJWorldGen.registerWorldGen(new WorldGenGroundCover(PVJBlocks.bones, 1, 150, PVJConfig.worldgen.bonesNetherDensity, BiomeReference.getValidBiomes(BiomeReference.NETHER_BIOMES)));
            }
            if (PVJConfig.master.enableSeashells) {
                PVJWorldGen.registerWorldGen(new WorldGenGroundCover(PVJBlocks.seashells, 60, 80, PVJConfig.worldgen.seashellsDensity, BiomeReference.getValidBiomes(BiomeReference.BEACH_BIOMES)));
            }
            if (PVJConfig.master.enablePinecones) {
                PVJWorldGen.registerWorldGen(new WorldGenGroundCover(PVJBlocks.pinecones, 60, 80, PVJConfig.worldgen.pineconesDensity, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.CONIFEROUS).toArray(new Biome[0])));
            }
        }
        PVJWorldGen.registerWorldGen(new WorldGenPVJPlant(PVJBlocks.wild_wheat, 60, 90, PVJConfig.worldgen.wildWheatDensity, PVJBiomes.prairie));
        PVJWorldGen.registerWorldGen(new WorldGenCrackedSand(PVJBlocks.cracked_sand, (Block)Blocks.field_150354_m, 60, 150, PVJConfig.worldgen.crackedSandDensity, BiomeReference.getValidBiomes(BiomeReference.DESERT_BIOMES)));
        PVJWorldGen.registerWorldGen(new WorldGenCrackedSand(PVJBlocks.red_cracked_sand, (Block)Blocks.field_150354_m, 60, 150, PVJConfig.worldgen.redCrackedSandDensity, BiomeReference.getValidBiomes(BiomeReference.MESA_BIOMES)));
        if (PVJConfig.master.enableOverworldPlants) {
            PVJWorldGen.registerWorldGen(new WorldGenShortGrass(PVJBlocks.short_grass, PVJConfig.worldgen.shortGrassDensity, BiomeReference.getValidBiomes(BiomeReference.OVERWORLD_BIOMES)));
            PVJWorldGen.registerWorldGen(new WorldGenPVJPlant(PVJBlocks.frost_lotus, 60, 255, PVJConfig.worldgen.frostLotusDensity, BiomeReference.getValidBiomes(BiomeReference.SNOWY_BIOMES)));
            PVJWorldGen.registerWorldGen(new WorldGenPVJPlant(PVJBlocks.silverleaf, 60, 255, PVJConfig.worldgen.silverleafDensity, BiomeReference.getValidBiomes(BiomeReference.OAK_TREES)));
            PVJWorldGen.registerWorldGen(new WorldGenPVJPlant(PVJBlocks.chickweed, 60, 255, PVJConfig.worldgen.chickweedDensity, BiomeReference.getValidBiomes(BiomeReference.FRESHWATER_BIOMES)));
            PVJWorldGen.registerWorldGen(new WorldGenPVJPlant(PVJBlocks.clovers, 60, 255, PVJConfig.worldgen.cloversDensity, BiomeReference.getValidBiomes(BiomeReference.FRESHWATER_BIOMES)));
            PVJWorldGen.registerWorldGen(new WorldGenPVJPlant(PVJBlocks.crabgrass, 60, 255, PVJConfig.worldgen.crabgrassDensity, BiomeReference.getValidBiomes(BiomeReference.FRESHWATER_BIOMES)));
            PVJWorldGen.registerWorldGen(new WorldGenPVJPlant(PVJBlocks.waxcap, 40, 190, PVJConfig.worldgen.waxcapDensity, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.FOREST).toArray(new Biome[0])));
            PVJWorldGen.registerWorldGen(new WorldGenPVJPlant(PVJBlocks.orange_mushroom, 40, 190, PVJConfig.worldgen.orangeMushroomDensity, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.FOREST).toArray(new Biome[0])));
            PVJWorldGen.registerWorldGen(new WorldGenPVJPlant(PVJBlocks.deathcap, 40, 190, PVJConfig.worldgen.deathcapDensity, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.FOREST).toArray(new Biome[0])));
            PVJWorldGen.registerWorldGen(new WorldGenPVJPlant(PVJBlocks.small_cactus, 40, 190, PVJConfig.worldgen.smallCactusDensity, BiomeReference.getValidBiomes(BiomeReference.DESERT_BIOMES)));
            PVJWorldGen.registerWorldGen(new WorldGenPVJPlant(PVJBlocks.small_cactus, 40, 190, PVJConfig.worldgen.smallCactusDensity, BiomeReference.getValidBiomes(BiomeReference.MESA_BIOMES)));
            PVJWorldGen.registerWorldGen(new WorldGenFloaters(true, PVJConfig.worldgen.lilypadRiverDensity, true));
            PVJWorldGen.registerWorldGen(new WorldGenFloaters(false, PVJConfig.worldgen.lilypadLakesDensity, false));
            PVJWorldGen.registerWorldGen(new WorldGenBracketFungus(PVJConfig.worldgen.bracketFungusDensity, BiomeReference.getValidBiomes(BiomeReference.FRESHWATER_BIOMES)));
            PVJWorldGen.registerWorldGen(new WorldGenRiverGrass(PVJConfig.worldgen.riverGrassDensity));
            PVJWorldGen.registerWorldGen(new WorldGenCattail(PVJConfig.worldgen.cattailDensity, BiomeReference.getValidBiomes(BiomeReference.FRESHWATER_BIOMES)));
        }
        if (PVJConfig.master.enableNetherPlants) {
            PVJWorldGen.registerWorldGen(new WorldGenPVJPlant(PVJBlocks.bloodnettle, 0, 255, PVJConfig.worldgen.bloodnettleDensity, BiomeReference.getValidBiomes(BiomeReference.NETHER_BIOMES)));
            PVJWorldGen.registerWorldGen(new WorldGenPVJPlant(PVJBlocks.glowcap, 0, 255, PVJConfig.worldgen.glowcapDensity, BiomeReference.getValidBiomes(BiomeReference.NETHER_BIOMES)));
        }
        if (Reference.isBOPLoaded) {
            PVJWorldGenerationBOP.initWorldGenBOP();
        }
    }

    public static void registerWorldGen(IWorldGenerator worldgen) {
        GameRegistry.registerWorldGenerator((IWorldGenerator)worldgen, (int)0);
    }
}

