/*
 * Decompiled with CFR 0.152.
 */
package vibrantjourneys.util;

import java.util.ArrayList;
import java.util.stream.Collectors;
import net.minecraft.block.BlockNewLog;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import vibrantjourneys.init.PVJBiomes;
import vibrantjourneys.integration.biomesoplenty.BiomeReferenceBOP;
import vibrantjourneys.util.Reference;

public class BiomeReference {
    public static final ArrayList<Biome> ALL_BIOMES = new ArrayList();
    public static final ArrayList<Biome> OVERWORLD_BIOMES = new ArrayList();
    public static final ArrayList<Biome> FRESHWATER_BIOMES = new ArrayList();
    public static final ArrayList<Biome> DESERT_BIOMES = new ArrayList();
    public static final ArrayList<Biome> MESA_BIOMES = new ArrayList();
    public static final ArrayList<Biome> BEACH_BIOMES = new ArrayList();
    public static final ArrayList<Biome> SNOWY_BIOMES = new ArrayList();
    public static final ArrayList<Biome> NETHER_BIOMES = new ArrayList();
    public static final ArrayList<Biome> END_BIOMES = new ArrayList();
    public static final ArrayList<Biome> MOSSY_COBBLESTONE_BIOMES = new ArrayList();
    public static final ArrayList<Biome> SANDSTONE_BIOMES = new ArrayList();
    public static final ArrayList<Biome> LILYPAD_BIOMES = new ArrayList();
    public static final ArrayList<Biome> OAK_TREES = new ArrayList();
    public static final ArrayList<Biome> BIRCH_TREES = new ArrayList();
    public static final ArrayList<Biome> SPRUCE_TREES = new ArrayList();
    public static final ArrayList<Biome> JUNGLE_TREES = new ArrayList();
    public static final ArrayList<Biome> ACACIA_TREES = new ArrayList();
    public static final ArrayList<Biome> DARKOAK_TREES = new ArrayList();
    public static final ArrayList<Biome> OAK_TREES_SPARSE = new ArrayList();
    public static final ArrayList<Biome> BIRCH_TREES_SPARSE = new ArrayList();
    public static final ArrayList<Biome> SPRUCE_TREES_SPARSE = new ArrayList();
    public static final ArrayList<Biome> JUNGLE_TREES_SPARSE = new ArrayList();
    public static final ArrayList<Biome> ACACIA_TREES_SPARSE = new ArrayList();
    public static final ArrayList<Biome> DARKOAK_TREES_SPARSE = new ArrayList();
    public static final ArrayList<Biome> WILLOW_TREES = new ArrayList();
    public static final ArrayList<Biome> MANGROVE_TREES = new ArrayList();
    public static final ArrayList<Biome> PALM_TREES = new ArrayList();
    public static final ArrayList<Biome> REDWOOD_TREES = new ArrayList();
    public static final ArrayList<Biome> FIR_TREES = new ArrayList();
    public static final ArrayList<Biome> PINE_TREES = new ArrayList();
    public static final ArrayList<Biome> ASPEN_TREES = new ArrayList();
    public static final ArrayList<Biome> RED_MAPLE_TREES = new ArrayList();
    public static final ArrayList<Biome> ORANGE_MAPLE_TREES = new ArrayList();
    public static final ArrayList<Biome> BAOBAB_TREES = new ArrayList();
    public static final ArrayList<Biome> BOP_MANGROVE_TREES = new ArrayList();
    public static final ArrayList<Biome> BOP_WILLOW_TREES = new ArrayList();
    public static final ArrayList<Biome> BOP_BAMBOO_TREES = new ArrayList();
    public static final ArrayList<Biome> BOP_FLOWERING_OAK_TREES = new ArrayList();
    public static final ArrayList<Biome> BOP_JACARANDA_TREES = new ArrayList();
    public static final ArrayList<Biome> BOP_MAGIC_TREES = new ArrayList();
    public static final ArrayList<Biome> BOP_EUCALYPTUS_TREES = new ArrayList();
    public static final ArrayList<Biome> BOP_EBONY_TREES = new ArrayList();
    public static final ArrayList<Biome> BOP_PINE_TREES = new ArrayList();
    public static final ArrayList<Biome> BOP_FIR_TREES = new ArrayList();
    public static final ArrayList<Biome> BOP_DEAD_TREES = new ArrayList();
    public static final ArrayList<Biome> BOP_REDWOOD_TREES = new ArrayList();
    public static final ArrayList<Biome> BOP_YELLOW_AUTUMN_TREES = new ArrayList();
    public static final ArrayList<Biome> BOP_ORANGE_AUTUMN_TREES = new ArrayList();
    public static final ArrayList<Biome> BOP_MAPLE_TREES = new ArrayList();
    public static final ArrayList<Biome> BOP_PALM_TREES = new ArrayList();
    public static final ArrayList<Biome> BOP_WHITE_CHERRY_TREES = new ArrayList();
    public static final ArrayList<Biome> BOP_PINK_CHERRY_TREES = new ArrayList();
    public static final ArrayList<Biome> BOP_MAHOGANY_TREES = new ArrayList();
    public static final ArrayList<Biome> BOP_UMBRAN_TREES = new ArrayList();
    public static final ArrayList<Biome> BOP_HELLBARK_TREES = new ArrayList();
    public static final ArrayList<Biome> BOP_SACRED_OAK_TREES = new ArrayList();
    public static final IBlockState OAK_LOG = Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.OAK);
    public static final IBlockState BIRCH_LOG = Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.BIRCH);
    public static final IBlockState SPRUCE_LOG = Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.SPRUCE);
    public static final IBlockState ACACIA_LOG = Blocks.field_150363_s.func_176223_P().func_177226_a((IProperty)BlockNewLog.field_176300_b, (Comparable)BlockPlanks.EnumType.ACACIA);

    public static void loadAllBiomeReferences() {
        BiomeReference.loadOakTrees();
        BiomeReference.loadBirchTrees();
        BiomeReference.loadSpruceTrees();
        BiomeReference.loadJungleTrees();
        BiomeReference.loadAcaciaTrees();
        BiomeReference.loadDarkOakTrees();
        BiomeReference.loadWillowTrees();
        BiomeReference.loadMangroveTrees();
        BiomeReference.loadPalmTrees();
        BiomeReference.loadRedwoodTrees();
        BiomeReference.loadFirTrees();
        BiomeReference.loadPineTrees();
        BiomeReference.loadAspenTrees();
        BiomeReference.loadMapleTrees();
        BiomeReference.loadBaobabTrees();
        ALL_BIOMES.addAll(ForgeRegistries.BIOMES.getValuesCollection());
        OVERWORLD_BIOMES.addAll(ALL_BIOMES.stream().filter(biome -> !BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.NETHER) && !BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.END)).collect(Collectors.toList()));
        FRESHWATER_BIOMES.addAll(OVERWORLD_BIOMES.stream().filter(biome -> !BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN) && !BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.BEACH)).collect(Collectors.toList()));
        SNOWY_BIOMES.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SNOWY));
        NETHER_BIOMES.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.NETHER));
        END_BIOMES.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.END));
        BEACH_BIOMES.addAll(OVERWORLD_BIOMES.stream().filter(biome -> BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.BEACH)).collect(Collectors.toList()));
        BiomeReference.loadMesaBiomes();
        BiomeReference.loadDesertBiomes();
        BiomeReference.loadMossyCobblestoneBiomes();
        BiomeReference.loadSandstoneBiomes();
        BiomeReference.loadLilyPadBiomes();
        if (Reference.isBOPLoaded) {
            BiomeReferenceBOP.loadBOPBiomes();
        }
    }

    public static void loadOakTrees() {
        OAK_TREES.add(Biomes.field_76767_f);
        OAK_TREES.add(Biomes.field_76785_t);
        OAK_TREES.add(Biomes.field_76780_h);
        OAK_TREES.add(Biomes.field_185444_T);
        OAK_TREES.add(Biomes.field_150599_m);
        OAK_TREES_SPARSE.add(Biomes.field_76782_w);
        OAK_TREES_SPARSE.add(Biomes.field_185446_X);
        OAK_TREES_SPARSE.add(Biomes.field_76772_c);
        OAK_TREES_SPARSE.add(Biomes.field_185441_Q);
        OAK_TREES_SPARSE.add(Biomes.field_150585_R);
        OAK_TREES_SPARSE.add(Biomes.field_185430_ab);
        OAK_TREES_SPARSE.add(PVJBiomes.prairie);
        OAK_TREES_SPARSE.add(PVJBiomes.aspen_grove);
    }

    public static void loadBirchTrees() {
        BIRCH_TREES.add(Biomes.field_150583_P);
        BIRCH_TREES.add(Biomes.field_150582_Q);
        BIRCH_TREES.add(Biomes.field_185448_Z);
        BIRCH_TREES.add(Biomes.field_185429_aa);
        BIRCH_TREES_SPARSE.add(Biomes.field_76767_f);
        BIRCH_TREES_SPARSE.add(Biomes.field_76785_t);
        BIRCH_TREES_SPARSE.add(Biomes.field_185444_T);
        BIRCH_TREES_SPARSE.add(Biomes.field_150585_R);
        BIRCH_TREES_SPARSE.add(Biomes.field_185430_ab);
    }

    public static void loadSpruceTrees() {
        SPRUCE_TREES.add(Biomes.field_150584_S);
        SPRUCE_TREES.add(Biomes.field_150579_T);
        SPRUCE_TREES.add(Biomes.field_150580_W);
        SPRUCE_TREES.add(Biomes.field_185432_ad);
        SPRUCE_TREES.add(Biomes.field_185433_ae);
        SPRUCE_TREES.add(Biomes.field_76768_g);
        SPRUCE_TREES.add(Biomes.field_76784_u);
        SPRUCE_TREES_SPARSE.add(Biomes.field_150580_W);
        SPRUCE_TREES_SPARSE.add(Biomes.field_185434_af);
        SPRUCE_TREES_SPARSE.add(Biomes.field_76783_v);
        SPRUCE_TREES_SPARSE.add(PVJBiomes.boreal_forest);
        SPRUCE_TREES_SPARSE.add(PVJBiomes.snowy_boreal_forest);
    }

    public static void loadJungleTrees() {
        JUNGLE_TREES.add(Biomes.field_76782_w);
        JUNGLE_TREES.add(Biomes.field_150574_L);
        JUNGLE_TREES.add(Biomes.field_76792_x);
        JUNGLE_TREES.add(Biomes.field_185446_X);
        JUNGLE_TREES.add(Biomes.field_185447_Y);
    }

    public static void loadAcaciaTrees() {
        ACACIA_TREES.add(Biomes.field_150588_X);
        ACACIA_TREES.add(Biomes.field_150587_Y);
        ACACIA_TREES.add(Biomes.field_185435_ag);
        ACACIA_TREES.add(Biomes.field_185436_ah);
    }

    public static void loadDarkOakTrees() {
        DARKOAK_TREES.add(Biomes.field_150585_R);
        DARKOAK_TREES.add(Biomes.field_185430_ab);
    }

    public static void loadWillowTrees() {
        WILLOW_TREES.add(PVJBiomes.willow_swamp);
    }

    public static void loadMangroveTrees() {
        MANGROVE_TREES.add(PVJBiomes.willow_swamp);
        MANGROVE_TREES.add(Biomes.field_76780_h);
        MANGROVE_TREES.add(Biomes.field_150599_m);
        MANGROVE_TREES.add(Biomes.field_76782_w);
        MANGROVE_TREES.add(Biomes.field_150574_L);
        MANGROVE_TREES.add(Biomes.field_76792_x);
        MANGROVE_TREES.add(Biomes.field_185446_X);
        MANGROVE_TREES.add(Biomes.field_185447_Y);
    }

    public static void loadPalmTrees() {
        PALM_TREES.add(Biomes.field_76787_r);
    }

    public static void loadRedwoodTrees() {
        REDWOOD_TREES.add(PVJBiomes.redwoods);
        REDWOOD_TREES.add(PVJBiomes.redwood_peaks);
    }

    public static void loadFirTrees() {
        FIR_TREES.add(PVJBiomes.boreal_forest);
        FIR_TREES.add(PVJBiomes.snowy_boreal_forest);
    }

    public static void loadPineTrees() {
        PINE_TREES.add(PVJBiomes.boreal_forest);
        PINE_TREES.add(PVJBiomes.snowy_boreal_forest);
    }

    public static void loadAspenTrees() {
        ASPEN_TREES.add(PVJBiomes.aspen_grove);
    }

    public static void loadMapleTrees() {
        RED_MAPLE_TREES.add(PVJBiomes.aspen_grove);
        ORANGE_MAPLE_TREES.add(PVJBiomes.aspen_grove);
    }

    public static void loadBaobabTrees() {
        BAOBAB_TREES.add(Biomes.field_150588_X);
        BAOBAB_TREES.add(Biomes.field_150587_Y);
        BAOBAB_TREES.add(Biomes.field_185435_ag);
        BAOBAB_TREES.add(Biomes.field_185436_ah);
    }

    public static void loadMesaBiomes() {
        MESA_BIOMES.add(Biomes.field_150589_Z);
        MESA_BIOMES.add(Biomes.field_150608_ab);
        MESA_BIOMES.add(Biomes.field_150607_aa);
        MESA_BIOMES.add(Biomes.field_185437_ai);
        MESA_BIOMES.add(Biomes.field_185439_ak);
        MESA_BIOMES.add(Biomes.field_185438_aj);
    }

    public static void loadDesertBiomes() {
        DESERT_BIOMES.add(Biomes.field_76769_d);
        DESERT_BIOMES.add(Biomes.field_76786_s);
        DESERT_BIOMES.add(Biomes.field_185442_R);
    }

    public static void loadMossyCobblestoneBiomes() {
        MOSSY_COBBLESTONE_BIOMES.add(Biomes.field_185432_ad);
        MOSSY_COBBLESTONE_BIOMES.add(Biomes.field_185433_ae);
        MOSSY_COBBLESTONE_BIOMES.add(Biomes.field_76780_h);
        MOSSY_COBBLESTONE_BIOMES.add(Biomes.field_150599_m);
        MOSSY_COBBLESTONE_BIOMES.add(PVJBiomes.redwoods);
        MOSSY_COBBLESTONE_BIOMES.add(Biomes.field_76782_w);
        MOSSY_COBBLESTONE_BIOMES.add(Biomes.field_150574_L);
        MOSSY_COBBLESTONE_BIOMES.add(Biomes.field_76792_x);
        MOSSY_COBBLESTONE_BIOMES.add(Biomes.field_185446_X);
        MOSSY_COBBLESTONE_BIOMES.add(Biomes.field_185447_Y);
    }

    public static void loadSandstoneBiomes() {
        SANDSTONE_BIOMES.addAll(DESERT_BIOMES);
        SANDSTONE_BIOMES.add(Biomes.field_76787_r);
    }

    public static void loadLilyPadBiomes() {
        for (Biome biome : FRESHWATER_BIOMES) {
            if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.DEAD) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MESA) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.DRY) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SNOWY) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SAVANNA) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.WASTELAND)) continue;
            LILYPAD_BIOMES.add(biome);
        }
    }

    public static Biome[] getValidBiomes(ArrayList<Biome> biomeList) {
        return biomeList.toArray(new Biome[0]);
    }
}

