/*
 * Decompiled with CFR 0.152.
 */
package vibrantjourneys.worldgen;

import java.util.Random;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraftforge.common.IPlantable;
import vibrantjourneys.blocks.BlockPVJLeaves;
import vibrantjourneys.blocks.BlockPVJSapling;
import vibrantjourneys.init.PVJBlocks;

public class WorldGenAspenTree
extends WorldGenAbstractTree {
    private static final IBlockState LOG = PVJBlocks.aspen_log.func_176223_P();
    private static final IBlockState LEAF = PVJBlocks.aspen_leaves.func_176223_P().func_177226_a((IProperty)BlockPVJLeaves.field_176236_b, (Comparable)Boolean.valueOf(false));

    public WorldGenAspenTree(boolean notify) {
        super(notify);
    }

    public boolean func_180709_b(World world, Random rand, BlockPos position) {
        int yGen = position.func_177956_o();
        int height = 10 + rand.nextInt(4);
        int base = 5 + rand.nextInt(2);
        if (yGen >= 1 && yGen + height + 1 <= 256) {
            boolean hasSpace = true;
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
            for (int y = yGen; y <= yGen + height + 1 && hasSpace; ++y) {
                int width = 2;
                for (int x = -width; x <= width && hasSpace; ++x) {
                    for (int z = -width; z <= width && hasSpace; ++z) {
                        if (y >= 0 && y < 256) {
                            int zPos;
                            int xPos = position.func_177958_n() + x;
                            if (this.isReplaceable(world, (BlockPos)pos.func_181079_c(xPos, y, zPos = position.func_177952_p() + z)) || world.func_180495_p((BlockPos)pos.func_181079_c(xPos, y, zPos)).func_177230_c() instanceof BlockTallGrass) continue;
                            hasSpace = false;
                            continue;
                        }
                        hasSpace = false;
                    }
                }
            }
            if (!hasSpace) {
                return false;
            }
            BlockPos down = position.func_177977_b();
            IBlockState state = world.func_180495_p(down);
            boolean isSoil = state.func_177230_c().canSustainPlant(state, (IBlockAccess)world, down, EnumFacing.UP, (IPlantable)((BlockPVJSapling)PVJBlocks.redwood_sapling));
            if (isSoil && yGen + height + 1 <= 256) {
                EnumFacing[] facings = new EnumFacing[]{EnumFacing.NORTH, EnumFacing.SOUTH, EnumFacing.EAST, EnumFacing.WEST};
                state.func_177230_c().onPlantGrow(state, world, down, position);
                int lowerBranch = 4 + rand.nextInt(2);
                for (int i = 0; i <= height; ++i) {
                    int z;
                    int x;
                    int y = position.func_177956_o() + height - i;
                    BlockPos logPos = new BlockPos(position.func_177958_n(), y, position.func_177952_p());
                    state = world.func_180495_p(logPos);
                    if (state.func_177230_c().isAir(state, (IBlockAccess)world, logPos) || state.func_177230_c().isLeaves(state, (IBlockAccess)world, logPos)) {
                        this.func_175903_a(world, logPos, LOG);
                        if (height - i > height - base - 1) {
                            this.genLeaves(world, logPos, rand, 1);
                        }
                    }
                    if (i == 2) {
                        for (EnumFacing facing : facings) {
                            x = position.func_177958_n() + facing.func_82601_c();
                            BlockPos branchPos = new BlockPos(x, y, z = position.func_177952_p() + facing.func_82599_e());
                            state = world.func_180495_p(branchPos);
                            if (!state.func_177230_c().isAir(state, (IBlockAccess)world, branchPos) && !state.func_177230_c().isLeaves(state, (IBlockAccess)world, branchPos)) continue;
                            this.func_175903_a(world, branchPos, LOG.func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.func_176870_a((EnumFacing.Axis)facing.func_176740_k())));
                            this.genLeaves(world, branchPos, rand, 1);
                        }
                    }
                    if (i != lowerBranch) continue;
                    block5: for (EnumFacing facing : facings) {
                        x = position.func_177958_n();
                        z = position.func_177952_p();
                        int yPos = y;
                        boolean shortBranch = false;
                        for (int j = 0; j < 3; ++j) {
                            BlockPos branchPos;
                            x += facing.func_82601_c();
                            z += facing.func_82599_e();
                            if (j == 2 && rand.nextBoolean()) {
                                shortBranch = true;
                                ++yPos;
                            }
                            if (j == 3) {
                                if (shortBranch) continue block5;
                                ++yPos;
                            }
                            if (!(state = world.func_180495_p(branchPos = new BlockPos(x, yPos, z))).func_177230_c().isAir(state, (IBlockAccess)world, branchPos) && !state.func_177230_c().isLeaves(state, (IBlockAccess)world, branchPos)) continue;
                            this.func_175903_a(world, branchPos, LOG.func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.func_176870_a((EnumFacing.Axis)facing.func_176740_k())));
                            this.genLeaves(world, branchPos, rand, 1);
                        }
                    }
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public void genLeaves(World world, BlockPos pos, Random rand, int radius) {
        for (int i = -radius; i <= radius; ++i) {
            for (int j = -radius; j <= radius; ++j) {
                for (int k = -radius; k <= radius; ++k) {
                    int x = pos.func_177958_n() + i;
                    int y = pos.func_177956_o() + j;
                    int z = pos.func_177952_p() + k;
                    BlockPos leafPos = new BlockPos(x, y, z);
                    IBlockState state = world.func_180495_p(leafPos);
                    if (Math.abs(i) != Math.abs(k)) {
                        if (!state.func_177230_c().canBeReplacedByLeaves(state, (IBlockAccess)world, leafPos)) continue;
                        this.func_175903_a(world, leafPos, LEAF);
                        continue;
                    }
                    if (rand.nextInt(5) != 0 || !state.func_177230_c().canBeReplacedByLeaves(state, (IBlockAccess)world, leafPos)) continue;
                    this.func_175903_a(world, leafPos, LEAF);
                }
            }
        }
        int x = pos.func_177958_n();
        int z = pos.func_177952_p();
        BlockPos leafPos = new BlockPos(x, pos.func_177956_o() + 1, z);
        IBlockState state = world.func_180495_p(leafPos);
        if (state.func_177230_c().canBeReplacedByLeaves(state, (IBlockAccess)world, leafPos)) {
            this.func_175903_a(world, leafPos, LEAF);
        }
    }
}

