/*
 * Decompiled with CFR 0.152.
 */
package vibrantjourneys.worldgen;

import java.util.Arrays;
import java.util.Random;
import net.minecraft.block.BlockLog;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;
import vibrantjourneys.blocks.BlockBracketFungus;
import vibrantjourneys.init.PVJBlocks;

public class WorldGenBracketFungus
implements IWorldGenerator {
    private int frequency;
    private Biome[] biomes;

    public WorldGenBracketFungus(int frequency, Biome ... biomes) {
        this.frequency = frequency;
        this.biomes = biomes;
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator generator, IChunkProvider provider) {
        int x = chunkX * 16 + 8;
        int z = chunkZ * 16 + 8;
        Biome biome = world.getBiomeForCoordsBody(new BlockPos(x, 0, z));
        if (Arrays.asList(this.biomes).contains(biome)) {
            for (int i = 0; i < this.frequency; ++i) {
                Random rand;
                EnumFacing facing;
                int xPos = x + random.nextInt(8) - random.nextInt(8);
                int zPos = z + random.nextInt(8) - random.nextInt(8);
                int yPos = 63 + random.nextInt(100);
                BlockPos pos = new BlockPos(xPos, yPos, zPos);
                IBlockState state = world.func_180495_p(pos.func_177984_a());
                if (!(state.func_177230_c() instanceof BlockLog) || !world.func_175623_d(pos.func_177972_a(facing = EnumFacing.Plane.HORIZONTAL.func_179518_a(rand = new Random())))) continue;
                world.func_175656_a(pos.func_177972_a(facing), PVJBlocks.bracket_fungus.func_176223_P().func_177226_a((IProperty)BlockBracketFungus.field_185512_D, (Comparable)facing));
            }
        }
    }
}

