/*
 * Decompiled with CFR 0.152.
 */
package vibrantjourneys.worldgen;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLilyPad;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockMushroom;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Loader;
import vibrantjourneys.blocks.BlockBracketFungus;
import vibrantjourneys.init.PVJBlocks;

public class WorldGenFallenTree
implements IWorldGenerator {
    private IBlockState logBase;
    private int frequency;
    private Biome[] biomes;

    public WorldGenFallenTree(IBlockState log, int frequency, Biome ... biomes) {
        this.logBase = log;
        this.frequency = frequency;
        this.biomes = biomes;
    }

    public WorldGenFallenTree(Block log, int frequency, Biome ... biomes) {
        this(log.func_176223_P(), frequency, biomes);
    }

    public void generate(Random rand, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        Random random = new Random();
        int x = chunkX * 16 + 8;
        int z = chunkZ * 16 + 8;
        int y = 0;
        Biome biome = world.getBiomeForCoordsBody(new BlockPos(x, 0, z));
        boolean isValidBiome = false;
        for (int i = 0; i < this.biomes.length; ++i) {
            if (biome != this.biomes[i]) continue;
            isValidBiome = true;
            break;
        }
        if (isValidBiome) {
            int i;
            int length = 3 + random.nextInt(4);
            boolean hasBranch = random.nextBoolean();
            EnumFacing facing = EnumFacing.Plane.HORIZONTAL.func_179518_a(random);
            int xPos = x;
            int zPos = z;
            for (i = 0; i < this.frequency; ++i) {
                xPos = x + random.nextInt(3);
                zPos = z + random.nextInt(3);
                y = 60 + random.nextInt(30);
                BlockPos testpos = new BlockPos(xPos, y, zPos);
                if (world.func_175623_d(testpos) && world.isSideSolid(testpos.func_177977_b(), EnumFacing.UP) && !(world.func_180495_p(testpos.func_177977_b()).func_177230_c() instanceof BlockLog)) break;
            }
            if (Loader.isModLoaded((String)"lostcities") && !world.func_175678_i(new BlockPos(xPos, y, zPos))) {
                for (i = 0; i < 255 - y; ++i) {
                    BlockPos pos = new BlockPos(xPos, y + i, zPos);
                    if (world.func_180495_p(pos).func_177230_c() instanceof BlockLeaves) continue;
                    return;
                }
            }
            if (!world.isSideSolid(new BlockPos(xPos, y - 1, zPos), EnumFacing.UP)) {
                return;
            }
            IBlockState log = this.logBase.func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.func_176870_a((EnumFacing.Axis)facing.func_176740_k()));
            for (int i2 = 0; i2 < length; ++i2) {
                BlockPos pos = new BlockPos(xPos += facing.func_82601_c(), y, zPos += facing.func_82599_e());
                IBlockState state = world.func_180495_p(pos);
                while (this.canReplace(world, pos.func_177977_b())) {
                    pos = pos.func_177977_b();
                    state = world.func_180495_p(pos);
                }
                if (!this.canReplace(world, pos)) break;
                world.func_175656_a(pos, log);
                EnumFacing facing2 = this.getHorizontalPerpendicular(facing.func_176736_b());
                if (world.func_175623_d(pos.func_177972_a(facing2))) {
                    // empty if block
                }
                if (random.nextBoolean()) {
                    world.func_175656_a(pos.func_177972_a(facing2), PVJBlocks.bracket_fungus.func_176223_P().func_177226_a((IProperty)BlockBracketFungus.field_185512_D, (Comparable)facing2));
                }
                if (!hasBranch || random.nextInt(length) >= i2) continue;
                EnumFacing branchfacing = this.getHorizontalPerpendicular(facing.func_176736_b());
                int xbranch = xPos + branchfacing.func_82601_c();
                int zbranch = zPos + branchfacing.func_82599_e();
                pos = new BlockPos(xbranch, y, zbranch);
                state = world.func_180495_p(pos);
                if (!this.canReplace(world, pos)) continue;
                while (this.canReplace(world, pos.func_177977_b())) {
                    pos = pos.func_177977_b();
                    state = world.func_180495_p(pos);
                }
                state = this.logBase.func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.func_176870_a((EnumFacing.Axis)branchfacing.func_176740_k()));
                world.func_175656_a(pos, state);
                facing2 = this.getHorizontalPerpendicular(branchfacing.func_176736_b());
                if (world.func_175623_d(pos.func_177972_a(facing2))) {
                    // empty if block
                }
                if (random.nextBoolean()) {
                    world.func_175656_a(pos.func_177972_a(facing2), PVJBlocks.bracket_fungus.func_176223_P().func_177226_a((IProperty)BlockBracketFungus.field_185512_D, (Comparable)facing2));
                }
                hasBranch = false;
            }
        }
    }

    public boolean canReplace(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        return world.func_175623_d(pos) || state.func_177230_c().func_176200_f((IBlockAccess)world, pos) || state.func_177230_c().isLeaves(state, (IBlockAccess)world, pos) || state.func_177230_c() instanceof BlockLilyPad || state.func_177230_c() instanceof BlockMushroom || state.func_177230_c() instanceof BlockFlower;
    }

    private EnumFacing getHorizontalPerpendicular(int facingIndex) {
        if (facingIndex == 0) {
            return EnumFacing.WEST;
        }
        if (facingIndex == 2) {
            return EnumFacing.EAST;
        }
        if (facingIndex == 1) {
            return EnumFacing.SOUTH;
        }
        return EnumFacing.NORTH;
    }
}

