/*
 * Decompiled with CFR 0.152.
 */
package vibrantjourneys.worldgen;

import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;
import vibrantjourneys.init.PVJBlocks;
import vibrantjourneys.util.BiomeReference;

public class WorldGenFloaters
implements IWorldGenerator {
    private boolean isRiver;
    private int frequency;
    private boolean checkDepth;

    public WorldGenFloaters(boolean isRiver, int frequency, boolean checkDepth) {
        this.isRiver = isRiver;
        this.frequency = frequency;
        this.checkDepth = checkDepth;
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        int x = chunkX * 16 + 8;
        int z = chunkZ * 16 + 8;
        Biome biome = world.getBiomeForCoordsBody(new BlockPos(x, 0, z));
        boolean isFreshwater = true;
        if (!BiomeReference.LILYPAD_BIOMES.contains(biome)) {
            isFreshwater = false;
        }
        if (this.isRiver && biome != Biomes.field_76781_i) {
            isFreshwater = false;
        }
        if (isFreshwater) {
            int yPos = 62;
            for (int i = 0; i < this.frequency; ++i) {
                int xPos = x + random.nextInt(8) - random.nextInt(8);
                int zPos = z + random.nextInt(8) - random.nextInt(8);
                if (!this.isRiver) {
                    BlockPos waterPos;
                    yPos = 60;
                    for (int j = 0; j < 20 && world.func_180495_p(waterPos = new BlockPos(xPos, ++yPos, zPos)).func_185904_a() != Material.field_151586_h; ++j) {
                    }
                }
                BlockPos pos = new BlockPos(xPos, yPos, zPos);
                IBlockState state = world.func_180495_p(pos);
                if (random.nextInt(4) != 0 || state.func_185904_a() != Material.field_151586_h) continue;
                if (this.checkDepth) {
                    int depth = 1;
                    for (int d = 2; d < 5 && (state = world.func_180495_p(pos.func_177979_c(d))).func_185904_a() == Material.field_151586_h; ++d) {
                        ++depth;
                    }
                    if (depth > 3 || !world.func_175623_d(pos.func_177984_a())) continue;
                    world.func_175656_a(pos.func_177984_a(), this.pickRandomFloater(world.field_73012_v));
                    continue;
                }
                if (!world.func_175623_d(pos.func_177984_a())) continue;
                world.func_175656_a(pos.func_177984_a(), this.pickRandomFloater(world.field_73012_v));
            }
        }
    }

    public IBlockState pickRandomFloater(Random rand) {
        int x = rand.nextInt(3);
        if (x == 0) {
            return Blocks.field_150392_bi.func_176223_P();
        }
        if (x == 1) {
            return PVJBlocks.frogbit.func_176223_P();
        }
        return PVJBlocks.duckweed.func_176223_P();
    }
}

