/*
 * Decompiled with CFR 0.152.
 */
package vibrantjourneys.worldgen;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;
import vibrantjourneys.blocks.BlockGroundCover;

public class WorldGenGroundCover
implements IWorldGenerator {
    private Block block;
    private int minY;
    private int maxY;
    private int frequency;
    private Biome[] biomes;

    public WorldGenGroundCover(Block block, int minY, int maxY, int frequency, Biome ... biomes) {
        this.block = block;
        this.minY = minY;
        this.maxY = maxY;
        this.frequency = frequency;
        this.biomes = biomes;
    }

    public void generate(Random rand, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        int i;
        Random random = new Random();
        if (world.field_73011_w.func_186058_p() != DimensionType.OVERWORLD && world.field_73011_w.func_186058_p() != DimensionType.NETHER) {
            return;
        }
        int x = chunkX * 16 + 8;
        int z = chunkZ * 16 + 8;
        Biome biome = world.getBiomeForCoordsBody(new BlockPos(x, 0, z));
        boolean isValidBiome = false;
        for (i = 0; i < this.biomes.length; ++i) {
            if (biome != this.biomes[i]) continue;
            isValidBiome = true;
            break;
        }
        if (isValidBiome) {
            for (i = 0; i < this.frequency; ++i) {
                int xPos = x + random.nextInt(8) - random.nextInt(8);
                int zPos = z + random.nextInt(8) - random.nextInt(8);
                int yPos = this.minY + random.nextInt(this.maxY - this.minY + 1);
                BlockPos pos = new BlockPos(xPos, yPos, zPos);
                int model = random.nextInt(5);
                if (!world.isSideSolid(pos.func_177977_b(), EnumFacing.UP) || !world.func_175623_d(pos)) continue;
                world.func_175656_a(pos, this.block.func_176223_P().func_177226_a((IProperty)BlockGroundCover.MODEL, (Comparable)Integer.valueOf(model)));
            }
        }
    }
}

