/*
 * Decompiled with CFR 0.152.
 */
package vibrantjourneys.worldgen;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.common.IWorldGenerator;

public class WorldGenPVJPlant
implements IWorldGenerator {
    private Block block;
    private int minY;
    private int maxY;
    private int frequency;
    private Biome[] biomes;

    public WorldGenPVJPlant(Block block, int minY, int maxY, int frequency, Biome ... biomes) {
        this.block = block;
        this.minY = minY;
        this.maxY = maxY;
        this.frequency = frequency;
        this.biomes = biomes;
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        int i;
        Random rand = new Random();
        int x = chunkX * 16 + 8;
        int z = chunkZ * 16 + 8;
        Biome biome = world.getBiomeForCoordsBody(new BlockPos(x, 0, z));
        boolean isValidBiome = false;
        for (i = 0; i < this.biomes.length; ++i) {
            if (biome != this.biomes[i]) continue;
            isValidBiome = true;
            break;
        }
        if (isValidBiome) {
            for (i = 0; i < this.frequency; ++i) {
                int xPos = x + rand.nextInt(7) - rand.nextInt(7);
                int zPos = z + rand.nextInt(7) - rand.nextInt(7);
                int yPos = this.minY + rand.nextInt(this.maxY - this.minY + 1);
                BlockPos pos = new BlockPos(xPos, yPos, zPos);
                IBlockState state = world.func_180495_p(pos.func_177977_b());
                if (!world.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)world, pos) || !state.func_177230_c().canSustainPlant(state, (IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP, (IPlantable)this.block) && !this.block.func_176196_c(world, pos.func_177977_b()) || !world.func_175623_d(pos) || !state.isSideSolid((IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP)) continue;
                world.func_175656_a(pos, this.block.func_176223_P());
            }
        }
    }
}

