/*
 * Decompiled with CFR 0.152.
 */
package vibrantjourneys.worldgen;

import java.util.Random;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraftforge.common.IPlantable;
import vibrantjourneys.blocks.BlockPVJLeaves;
import vibrantjourneys.blocks.BlockPVJSapling;
import vibrantjourneys.init.PVJBlocks;

public class WorldGenRedwoodSmall
extends WorldGenAbstractTree {
    private static final IBlockState LOG = PVJBlocks.redwood_log.func_176223_P();
    private static final IBlockState LEAF = PVJBlocks.redwood_leaves.func_176223_P().func_177226_a((IProperty)BlockPVJLeaves.field_176236_b, (Comparable)Boolean.valueOf(false));

    public WorldGenRedwoodSmall() {
        super(false);
    }

    public boolean func_180709_b(World world, Random rand, BlockPos position) {
        IBlockState BARK = PVJBlocks.redwood_bark.func_176223_P();
        int yGen = position.func_177956_o();
        int height = 9 + rand.nextInt(3);
        int crown = height - 8 + rand.nextInt(3);
        int base = height - crown;
        if (yGen >= 1 && yGen + height + 1 <= 256) {
            boolean hasSpace = true;
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
            for (int y = yGen; y <= yGen + height + 1 && hasSpace; ++y) {
                int width = 2;
                if (y - yGen < base) {
                    width = 1;
                }
                for (int x = -width; x <= width && hasSpace; ++x) {
                    for (int z = -width; z <= width && hasSpace; ++z) {
                        if (y >= 0 && y < 256) {
                            int zPos;
                            int xPos = position.func_177958_n() + x;
                            if (this.isReplaceable(world, (BlockPos)pos.func_181079_c(xPos, y, zPos = position.func_177952_p() + z)) || world.func_180495_p((BlockPos)pos.func_181079_c(xPos, y, zPos)).func_177230_c() instanceof BlockTallGrass) continue;
                            hasSpace = false;
                            continue;
                        }
                        hasSpace = false;
                    }
                }
            }
            if (!hasSpace) {
                return false;
            }
            BlockPos down = position.func_177977_b();
            IBlockState state = world.func_180495_p(down);
            boolean isSoil = state.func_177230_c().canSustainPlant(state, (IBlockAccess)world, down, EnumFacing.UP, (IPlantable)((BlockPVJSapling)PVJBlocks.redwood_sapling));
            if (isSoil && yGen + height + 1 <= 256) {
                state.func_177230_c().onPlantGrow(state, world, down, position);
                int tempwidth = 0;
                for (int h = 0; h <= height; ++h) {
                    BlockPos genPos = position.func_177981_b(h);
                    state = world.func_180495_p(genPos);
                    if (state.func_177230_c().isAir(state, (IBlockAccess)world, genPos) || state.func_177230_c().isLeaves(state, (IBlockAccess)world, genPos)) {
                        this.func_175903_a(world, genPos, LOG);
                    }
                    if (h == 0) {
                        this.func_175903_a(world, genPos.func_177974_f(), BARK);
                        this.func_175903_a(world, genPos.func_177976_e(), BARK);
                        this.func_175903_a(world, genPos.func_177978_c(), BARK);
                        this.func_175903_a(world, genPos.func_177968_d(), BARK);
                    }
                    if (h == 1) {
                        if (rand.nextInt(10) < 7) {
                            this.func_175903_a(world, genPos.func_177974_f(), BARK);
                            if (rand.nextInt(10) < 6) {
                                this.func_175903_a(world, genPos.func_177974_f().func_177984_a(), BARK);
                            }
                        }
                        if (rand.nextInt(10) < 7) {
                            this.func_175903_a(world, genPos.func_177976_e(), BARK);
                            if (rand.nextInt(10) < 6) {
                                this.func_175903_a(world, genPos.func_177976_e().func_177984_a(), BARK);
                            }
                        }
                        if (rand.nextInt(10) < 7) {
                            this.func_175903_a(world, genPos.func_177978_c(), BARK);
                            if (rand.nextInt(10) < 6) {
                                this.func_175903_a(world, genPos.func_177978_c().func_177984_a(), BARK);
                            }
                        }
                        if (rand.nextInt(10) < 7) {
                            this.func_175903_a(world, genPos.func_177978_c(), BARK);
                            if (rand.nextInt(10) < 6) {
                                this.func_175903_a(world, genPos.func_177978_c().func_177984_a(), BARK);
                            }
                        }
                    }
                    if (h < base) continue;
                    int mid = crown / 2 + base;
                    int width = h < mid ? h - base + 1 : height - h + 1;
                    if (width > 3) {
                        width = 3;
                    }
                    if (Math.abs(width - tempwidth) > 1) {
                        --width;
                    }
                    for (int x = -width; x <= width; ++x) {
                        for (int z = -width; z <= width; ++z) {
                            int xPos = genPos.func_177958_n() + x;
                            int zPos = genPos.func_177952_p() + z;
                            int yPos = genPos.func_177956_o();
                            BlockPos leafPos = new BlockPos(xPos, yPos, zPos);
                            if (leafPos.equals((Object)genPos) || !state.func_177230_c().isAir(state, (IBlockAccess)world, leafPos) && !state.func_177230_c().isLeaves(state, (IBlockAccess)world, leafPos)) continue;
                            if (Math.abs(x) == Math.abs(z) && x == width) {
                                if (rand.nextInt(9) >= 5) continue;
                                this.func_175903_a(world, leafPos, LEAF);
                                continue;
                            }
                            this.func_175903_a(world, leafPos, LEAF);
                        }
                    }
                    tempwidth = width;
                }
                this.func_175903_a(world, position.func_177981_b(height + 1), LEAF);
                return true;
            }
            return false;
        }
        return false;
    }
}

