/*
 * Decompiled with CFR 0.152.
 */
package vibrantjourneys.worldgen;

import java.util.Random;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.common.IWorldGenerator;
import vibrantjourneys.blocks.BlockShortGrass;
import vibrantjourneys.init.PVJBlocks;

public class WorldGenRiverGrass
implements IWorldGenerator {
    private int frequency;

    public WorldGenRiverGrass(int frequency) {
        this.frequency = frequency;
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (world.field_73011_w.func_186058_p() != DimensionType.OVERWORLD && world.field_73011_w.func_186058_p() != DimensionType.NETHER) {
            return;
        }
        int x = chunkX * 16 + 8;
        int z = chunkZ * 16 + 8;
        Biome biome = world.getBiomeForCoordsBody(new BlockPos(x, 0, z));
        if (biome == Biomes.field_76781_i) {
            BlockPos pos = world.func_175672_r(new BlockPos(x, 0, z));
            int xPos = pos.func_177958_n();
            int yPos = pos.func_177956_o();
            int zPos = pos.func_177952_p();
            for (BlockPos position : BlockPos.func_177975_b((BlockPos)new BlockPos(xPos - 7, yPos - 10, zPos - 7), (BlockPos)new BlockPos(xPos + 7, yPos + 10, zPos + 7))) {
                BlockTallGrass block;
                IBlockState state = world.func_180495_p(position.func_177977_b());
                if (!state.func_177230_c().canSustainPlant(state, (IBlockAccess)world, position.func_177977_b(), EnumFacing.UP, (IPlantable)Blocks.field_150329_H) || random.nextInt(100) >= this.frequency) continue;
                int model = random.nextInt(7);
                Object object = block = random.nextBoolean() ? Blocks.field_150329_H : PVJBlocks.short_grass;
                if (random.nextInt(2) != 0 || !world.func_175623_d(position)) continue;
                if (block == PVJBlocks.short_grass) {
                    world.func_175656_a(position, block.func_176223_P().func_177226_a((IProperty)BlockShortGrass.MODEL, (Comparable)Integer.valueOf(model)));
                    continue;
                }
                world.func_175656_a(position, block.func_176223_P().func_177226_a((IProperty)BlockTallGrass.field_176497_a, (Comparable)BlockTallGrass.EnumType.GRASS));
            }
        }
    }
}

