/*
 * Decompiled with CFR 0.152.
 */
package vibrantjourneys.worldgen;

import java.util.Random;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenHugeTrees;
import vibrantjourneys.blocks.BlockPVJLeaves;
import vibrantjourneys.init.PVJBlocks;

public class WorldGenSequoiaTree
extends WorldGenHugeTrees {
    private static final IBlockState LOG = PVJBlocks.redwood_log.func_176223_P();
    private static final IBlockState LEAF = PVJBlocks.redwood_leaves.func_176223_P().func_177226_a((IProperty)BlockPVJLeaves.field_176236_b, (Comparable)Boolean.valueOf(false));

    public WorldGenSequoiaTree(boolean notify, int baseHeightIn, int extraRandomHeightIn) {
        super(notify, baseHeightIn, extraRandomHeightIn, LOG, LEAF);
    }

    public boolean func_180709_b(World world, Random rand, BlockPos position) {
        IBlockState BARK = PVJBlocks.redwood_bark.func_176223_P();
        int i = this.func_150533_a(rand);
        if (!this.func_175929_a(world, rand, position, i)) {
            return false;
        }
        this.createCrown(world, position.func_177981_b(i), 0, rand);
        for (int j = 0; j < i; ++j) {
            if (this.isAirLeaves(world, position.func_177981_b(j))) {
                this.func_175903_a(world, position.func_177981_b(j), this.field_76520_b);
            }
            if (j >= i - 1) continue;
            if (this.isAirLeaves(world, position.func_177982_a(1, j, 0))) {
                this.func_175903_a(world, position.func_177982_a(1, j, 0), this.field_76520_b);
            }
            if (this.isAirLeaves(world, position.func_177982_a(1, j, 1))) {
                this.func_175903_a(world, position.func_177982_a(1, j, 1), this.field_76520_b);
            }
            if (!this.isAirLeaves(world, position.func_177982_a(0, j, 1))) continue;
            this.func_175903_a(world, position.func_177982_a(0, j, 1), this.field_76520_b);
        }
        for (int i2 = 0; i2 < i; ++i2) {
            BlockPos blockpos = position.func_177981_b(i2);
            if (this.isAirLeaves(world, blockpos)) {
                this.func_175903_a(world, blockpos, this.field_76520_b);
            }
            if (i2 < i - 1) {
                BlockPos blockpos3;
                BlockPos blockpos2;
                BlockPos blockpos1 = blockpos.func_177974_f();
                if (this.isAirLeaves(world, blockpos1)) {
                    this.func_175903_a(world, blockpos1, this.field_76520_b);
                }
                if (this.isAirLeaves(world, blockpos2 = blockpos.func_177968_d().func_177974_f())) {
                    this.func_175903_a(world, blockpos2, this.field_76520_b);
                }
                if (this.isAirLeaves(world, blockpos3 = blockpos.func_177968_d())) {
                    this.func_175903_a(world, blockpos3, this.field_76520_b);
                }
            }
            if (i2 != 0) continue;
            for (int ilike = -2; ilike < 2; ++ilike) {
                int height = 3 + rand.nextInt(3);
                int rootStart = 0;
                BlockPos blockpos1 = blockpos.func_177978_c().func_177985_f(ilike);
                while ((world.func_180495_p(blockpos1.func_177981_b(rootStart)).func_177230_c().func_176200_f((IBlockAccess)world, blockpos1.func_177981_b(rootStart)) || this.isAirLeaves(world, blockpos1.func_177981_b(rootStart))) && --rootStart >= -5) {
                }
                for (int tacos = rootStart; tacos < height; ++tacos) {
                    if (!this.isAirLeaves(world, blockpos1.func_177981_b(tacos))) continue;
                    this.func_175903_a(world, blockpos1.func_177981_b(tacos), BARK);
                }
                height = 3 + rand.nextInt(3);
                rootStart = 0;
                BlockPos blockpos2 = blockpos.func_177970_e(2).func_177985_f(ilike);
                while ((world.func_180495_p(blockpos2.func_177981_b(rootStart)).func_177230_c().func_176200_f((IBlockAccess)world, blockpos2.func_177981_b(rootStart)) || this.isAirLeaves(world, blockpos2.func_177981_b(rootStart))) && --rootStart >= -5) {
                }
                for (int sausages = rootStart; sausages < height; ++sausages) {
                    if (!this.isAirLeaves(world, blockpos2.func_177981_b(sausages))) continue;
                    this.func_175903_a(world, blockpos2.func_177981_b(sausages), BARK);
                }
            }
            for (int jugs = 0; jugs < 2; ++jugs) {
                int height = 3 + rand.nextInt(3);
                int rootStart = 0;
                BlockPos blockpos3 = blockpos.func_177976_e().func_177970_e(jugs);
                while ((world.func_180495_p(blockpos3.func_177981_b(rootStart)).func_177230_c().func_176200_f((IBlockAccess)world, blockpos3.func_177981_b(rootStart)) || this.isAirLeaves(world, blockpos3.func_177981_b(rootStart))) && --rootStart >= -5) {
                }
                for (int and = rootStart; and < height; ++and) {
                    if (!this.isAirLeaves(world, blockpos3.func_177981_b(and))) continue;
                    this.func_175903_a(world, blockpos3.func_177981_b(and), BARK);
                }
                height = 3 + rand.nextInt(3);
                rootStart = 0;
                BlockPos blockpos4 = blockpos.func_177965_g(2).func_177970_e(jugs);
                while ((world.func_180495_p(blockpos4.func_177981_b(rootStart)).func_177230_c().func_176200_f((IBlockAccess)world, blockpos4.func_177981_b(rootStart)) || this.isAirLeaves(world, blockpos4.func_177981_b(rootStart))) && --rootStart >= -5) {
                }
                for (int buns = rootStart; buns < height; ++buns) {
                    if (!this.isAirLeaves(world, blockpos4.func_177981_b(buns))) continue;
                    this.func_175903_a(world, blockpos4.func_177981_b(buns), BARK);
                }
            }
            for (int l = 0; l < 2; ++l) {
                int height = 1 + rand.nextInt(3);
                int rootStart = 0;
                BlockPos blockpos5 = blockpos.func_177985_f(2).func_177970_e(l);
                while ((world.func_180495_p(blockpos5.func_177981_b(rootStart)).func_177230_c().func_176200_f((IBlockAccess)world, blockpos5.func_177981_b(rootStart)) || this.isAirLeaves(world, blockpos5.func_177981_b(rootStart))) && --rootStart >= -5) {
                }
                for (int g = rootStart; g < height; ++g) {
                    if (!this.isAirLeaves(world, blockpos5.func_177981_b(g))) continue;
                    this.func_175903_a(world, blockpos5.func_177981_b(g), BARK);
                }
                height = 1 + rand.nextInt(3);
                rootStart = 0;
                BlockPos blockpos6 = blockpos.func_177965_g(3).func_177970_e(l);
                while ((world.func_180495_p(blockpos6.func_177981_b(rootStart)).func_177230_c().func_176200_f((IBlockAccess)world, blockpos6.func_177981_b(rootStart)) || this.isAirLeaves(world, blockpos6.func_177981_b(rootStart))) && --rootStart >= -5) {
                }
                for (int b = rootStart; b < height; ++b) {
                    if (!this.isAirLeaves(world, blockpos6.func_177981_b(b))) continue;
                    this.func_175903_a(world, blockpos6.func_177981_b(b), BARK);
                }
                height = 1 + rand.nextInt(3);
                rootStart = 0;
                BlockPos blockpos7 = blockpos.func_177964_d(2).func_177965_g(l);
                while ((world.func_180495_p(blockpos7.func_177981_b(rootStart)).func_177230_c().func_176200_f((IBlockAccess)world, blockpos7.func_177981_b(rootStart)) || this.isAirLeaves(world, blockpos7.func_177981_b(rootStart))) && --rootStart >= -5) {
                }
                for (int t = rootStart; t < height; ++t) {
                    if (!this.isAirLeaves(world, blockpos7.func_177981_b(t))) continue;
                    this.func_175903_a(world, blockpos7.func_177981_b(t), BARK);
                }
                height = 1 + rand.nextInt(3);
                rootStart = 0;
                BlockPos blockpos8 = blockpos.func_177970_e(3).func_177965_g(l);
                while ((world.func_180495_p(blockpos8.func_177981_b(rootStart)).func_177230_c().func_176200_f((IBlockAccess)world, blockpos8.func_177981_b(rootStart)) || this.isAirLeaves(world, blockpos8.func_177981_b(rootStart))) && --rootStart >= -5) {
                }
                for (int pride = rootStart; pride < height; ++pride) {
                    if (!this.isAirLeaves(world, blockpos8.func_177981_b(pride))) continue;
                    this.func_175903_a(world, blockpos8.func_177981_b(pride), BARK);
                }
            }
        }
        return true;
    }

    private void createCrown(World worldIn, BlockPos pos, int p_150541_5_, Random rand) {
        int i = rand.nextInt(5) + (this.field_76522_a - 5);
        int j = 0;
        int y = pos.func_177956_o();
        int x = pos.func_177958_n();
        int z = pos.func_177952_p();
        for (int k = y - i; k <= y; ++k) {
            int l = y - k;
            int i1 = p_150541_5_ + MathHelper.func_76141_d((float)((float)l / (float)i * 3.5f));
            this.func_175925_a(worldIn, new BlockPos(x, k, z), i1 + (l > 0 && i1 == j && (k & 1) == 0 ? 1 : 0));
            j = i1;
        }
    }

    private boolean isAirLeaves(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        return state.func_177230_c().isAir(state, (IBlockAccess)world, pos) || state.func_177230_c().isLeaves(state, (IBlockAccess)world, pos);
    }
}

