/*
 * Decompiled with CFR 0.152.
 */
package vibrantjourneys.worldgen;

import java.util.Random;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.common.IWorldGenerator;

public class WorldGenSmallBush
implements IWorldGenerator {
    private int frequency;
    private Biome[] biomes;

    public WorldGenSmallBush(int frequency, Biome ... biomes) {
        this.frequency = frequency;
        this.biomes = biomes;
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        int i;
        int x = chunkX * 16 + 8;
        int z = chunkZ * 16 + 8;
        Biome biome = world.getBiomeForCoordsBody(new BlockPos(x, 0, z));
        boolean isValidBiome = false;
        for (i = 0; i < this.biomes.length; ++i) {
            if (biome != this.biomes[i]) continue;
            isValidBiome = true;
            break;
        }
        if (isValidBiome) {
            for (i = 0; i < 10; ++i) {
                IBlockState soil;
                int xPos = x + random.nextInt(4) - random.nextInt(4);
                int zPos = z + random.nextInt(4) - random.nextInt(4);
                int yPos = 63 + random.nextInt(13);
                BlockPos pos = new BlockPos(xPos, yPos, zPos);
                if (random.nextInt(20) >= this.frequency || !world.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)world, pos) || !(soil = world.func_180495_p(pos.func_177977_b())).func_177230_c().canSustainPlant(soil, (IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP, (IPlantable)((BlockSapling)Blocks.field_150345_g))) continue;
                world.func_175656_a(pos, Blocks.field_150364_r.func_176223_P());
                if (world.func_180495_p(pos.func_177984_a()).func_177230_c().func_176200_f((IBlockAccess)world, pos.func_177984_a())) {
                    world.func_175656_a(pos.func_177984_a(), Blocks.field_150362_t.func_176223_P());
                }
                if (world.func_180495_p(pos.func_177978_c()).func_177230_c().func_176200_f((IBlockAccess)world, pos.func_177978_c())) {
                    world.func_175656_a(pos.func_177978_c(), Blocks.field_150362_t.func_176223_P());
                }
                if (world.func_180495_p(pos.func_177976_e()).func_177230_c().func_176200_f((IBlockAccess)world, pos.func_177976_e())) {
                    world.func_175656_a(pos.func_177976_e(), Blocks.field_150362_t.func_176223_P());
                }
                if (world.func_180495_p(pos.func_177968_d()).func_177230_c().func_176200_f((IBlockAccess)world, pos.func_177968_d())) {
                    world.func_175656_a(pos.func_177968_d(), Blocks.field_150362_t.func_176223_P());
                }
                if (!world.func_180495_p(pos.func_177974_f()).func_177230_c().func_176200_f((IBlockAccess)world, pos.func_177974_f())) continue;
                world.func_175656_a(pos.func_177974_f(), Blocks.field_150362_t.func_176223_P());
            }
        }
    }
}

