/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.reap.config;

import de.maxhenkel.reap.config.Selector;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;

public class BlockSelector
implements Selector<IBlockState> {
    private Block block;
    private int meta;

    public BlockSelector(Block block, int meta) {
        this.block = block;
        this.meta = meta;
    }

    public BlockSelector(Block block) {
        this.block = block;
        this.meta = -1;
    }

    public Block getBlock() {
        return this.block;
    }

    public int getMeta() {
        return this.meta;
    }

    @Nullable
    public static BlockSelector fromString(String str) {
        String[] split = str.split(":");
        if (split.length < 2) {
            return null;
        }
        Block block = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(split[0], split[1]));
        if (block == null || block.equals(Blocks.field_150350_a)) {
            return null;
        }
        int meta = -1;
        if (split.length >= 3) {
            try {
                meta = Integer.parseInt(split[2]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return new BlockSelector(block, meta);
    }

    public String toString() {
        if (this.block == null || this.block.equals(Blocks.field_150350_a)) {
            return "";
        }
        ResourceLocation loc = this.block.getRegistryName();
        String str = loc.func_110624_b() + ":" + loc.func_110623_a();
        if (this.meta >= 0) {
            str = str + ":" + this.meta;
        }
        return str;
    }

    @Override
    public boolean isValid(IBlockState state) {
        if (this.block == null || state == null || state.func_177230_c() == null) {
            return false;
        }
        if (!this.block.equals(state.func_177230_c())) {
            return false;
        }
        if (this.meta < 0) {
            return true;
        }
        return this.meta == this.block.func_176201_c(state);
    }

    public static boolean contains(List<BlockSelector> list, IBlockState state) {
        for (BlockSelector selector : list) {
            if (!selector.isValid(state)) continue;
            return true;
        }
        return false;
    }
}

