/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.reap.config;

import de.maxhenkel.reap.config.BlockSelector;
import de.maxhenkel.reap.config.ItemStackSelector;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraftforge.common.config.Configuration;

public class Config {
    public static List<BlockSelector> reapWhitelist = new ArrayList<BlockSelector>();
    public static List<BlockSelector> logTypes = new ArrayList<BlockSelector>();
    public static List<BlockSelector> groundTypes = new ArrayList<BlockSelector>();
    public static List<ItemStackSelector> allowedTreeTools = new ArrayList<ItemStackSelector>();
    public static boolean enableTreeHarvest = true;

    public Config(Configuration cfg) {
        enableTreeHarvest = cfg.getBoolean("enable_tree_harvest", "", true, "");
        reapWhitelist = Config.getBlockList(cfg, "whitelist", "", "", new BlockSelector[]{new BlockSelector(Blocks.field_150469_bN), new BlockSelector(Blocks.field_150459_bM), new BlockSelector(Blocks.field_150464_aj), new BlockSelector(Blocks.field_185773_cZ), new BlockSelector(Blocks.field_150375_by)});
        logTypes = Config.getBlockList(cfg, "log_types", "", "", new BlockSelector[]{new BlockSelector(Blocks.field_150364_r), new BlockSelector(Blocks.field_150363_s)});
        groundTypes = Config.getBlockList(cfg, "tree_ground_blocks", "", "", new BlockSelector[]{new BlockSelector(Blocks.field_150346_d), new BlockSelector((Block)Blocks.field_150349_c)});
        allowedTreeTools = Config.getStackList(cfg, "allowed_tree_tools", "", "", new ItemStackSelector[]{new ItemStackSelector(Items.field_151053_p), new ItemStackSelector(Items.field_151006_E), new ItemStackSelector(Items.field_151049_t), new ItemStackSelector(Items.field_151036_c), new ItemStackSelector(Items.field_151056_x)});
        cfg.save();
    }

    public static List<ItemStackSelector> getStackList(Configuration config, String name, String category, String comment, ItemStackSelector[] defaultValues) {
        String[] def = new String[defaultValues.length];
        for (int i = 0; i < def.length; ++i) {
            def[i] = defaultValues[i].toString();
        }
        ArrayList<ItemStackSelector> stackList = new ArrayList<ItemStackSelector>();
        String[] array = config.getStringList(name, category, def, comment);
        if (array == null) {
            return stackList;
        }
        for (String s : array) {
            ItemStackSelector selector = ItemStackSelector.fromString(s);
            if (selector == null) continue;
            stackList.add(selector);
        }
        return stackList;
    }

    public static List<BlockSelector> getBlockList(Configuration config, String name, String category, String comment, BlockSelector[] defaultValues) {
        String[] def = new String[defaultValues.length];
        for (int i = 0; i < def.length; ++i) {
            def[i] = defaultValues[i].toString();
        }
        ArrayList<BlockSelector> stackList = new ArrayList<BlockSelector>();
        String[] array = config.getStringList(name, category, def, comment);
        if (array == null) {
            return stackList;
        }
        for (String s : array) {
            BlockSelector selector = BlockSelector.fromString(s);
            if (selector == null) continue;
            stackList.add(selector);
        }
        return stackList;
    }
}

