/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.reap;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

public class Config {
    public static final ServerConfig SERVER;
    public static final ForgeConfigSpec SERVER_SPEC;
    private static ForgeConfigSpec.ConfigValue<List<? extends String>> reapWhitelist;
    private static ForgeConfigSpec.ConfigValue<List<? extends String>> logTypes;
    private static ForgeConfigSpec.ConfigValue<List<? extends String>> groundTypes;
    private static ForgeConfigSpec.ConfigValue<List<? extends String>> allowedTreeTools;
    private static ForgeConfigSpec.BooleanValue treeHarvest;

    public static List<Block> getReapWhitelist() {
        return ((List)reapWhitelist.get()).stream().map(s -> Config.getBlock(s)).filter(b -> b != null).collect(Collectors.toList());
    }

    public static List<Block> getLogTypes() {
        return ((List)logTypes.get()).stream().map(s -> Config.getBlock(s)).filter(b -> b != null).collect(Collectors.toList());
    }

    public static List<Block> getGroundTypes() {
        return ((List)groundTypes.get()).stream().map(s -> Config.getBlock(s)).filter(b -> b != null).collect(Collectors.toList());
    }

    public static List<Item> getAllowedTreeTools() {
        return ((List)allowedTreeTools.get()).stream().map(s -> Config.getItem(s)).filter(b -> b != null).collect(Collectors.toList());
    }

    public static boolean getTreeHarvest() {
        return (Boolean)treeHarvest.get();
    }

    @Nullable
    private static Block getBlock(String name) {
        try {
            String[] split = name.split(":");
            if (split.length == 2) {
                Block b = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(split[0], split[1]));
                return b;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    private static Item getItem(String name) {
        try {
            String[] split = name.split(":");
            if (split.length == 2) {
                Item i = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(split[0], split[1]));
                return i;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    static {
        Pair specPairServer = new ForgeConfigSpec.Builder().configure(ServerConfig::new);
        SERVER_SPEC = (ForgeConfigSpec)specPairServer.getRight();
        SERVER = (ServerConfig)specPairServer.getLeft();
    }

    public static class ServerConfig {
        public ServerConfig(ForgeConfigSpec.Builder builder) {
            reapWhitelist = builder.comment("The blocks that should get harvested by right-clicking").defineList("reap_whitelist", Arrays.asList("minecraft:potatoes", "minecraft:carrots", "minecraft:wheat", "minecraft:beetroots", "minecraft:cocoa"), Objects::nonNull);
            logTypes = builder.comment("The log blocks that are allowed to get harvested by the tree harvester").defineList("log_types", Arrays.asList("minecraft:acacia_log", "minecraft:birch_log", "minecraft:dark_oak_log", "minecraft:jungle_log", "minecraft:oak_log", "minecraft:spruce_log"), Objects::nonNull);
            groundTypes = builder.comment("The blocks that are allowed below logs that can be harvested").defineList("ground_types", Arrays.asList("minecraft:dirt", "minecraft:grass_block", "minecraft:coarse_dirt", "minecraft:podzol", "minecraft:mycelium"), Objects::nonNull);
            allowedTreeTools = builder.comment("The tools which the player is allowed to harvest trees").defineList("allowed_tree_tools", Arrays.asList("minecraft:wooden_axe", "minecraft:golden_axe", "minecraft:stone_axe", "minecraft:iron_axe", "minecraft:diamond_axe"), Objects::nonNull);
            treeHarvest = builder.comment("If the tree harvester should be enabled").define("tree_harvest", true);
        }
    }
}

