/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.reap;

import de.maxhenkel.reap.Config;
import java.util.ArrayList;
import net.minecraft.block.BlockState;
import net.minecraft.block.LogBlock;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class TreeHarvester {
    private BlockPos pos;
    private PlayerEntity player;
    private IWorld world;
    private ItemStack heldItem;

    public TreeHarvester(BlockPos pos, PlayerEntity player, IWorld world) {
        this.pos = pos;
        this.player = player;
        this.world = world;
        this.heldItem = player.func_184614_ca();
    }

    public void harvest() {
        if (!Config.getTreeHarvest()) {
            return;
        }
        if (this.heldItem == null) {
            return;
        }
        Item item = this.heldItem.func_77973_b();
        if (item == null) {
            return;
        }
        if (this.player.func_70093_af()) {
            return;
        }
        if (Config.getAllowedTreeTools().stream().noneMatch(i -> i.equals(this.heldItem.func_77973_b()))) {
            return;
        }
        if (!this.isLog(this.pos)) {
            return;
        }
        if (!this.isGround(this.pos.func_177977_b())) {
            return;
        }
        if (!((Direction.Axis)this.world.func_180495_p(this.pos).func_177229_b((IProperty)LogBlock.field_176298_M)).equals((Object)Direction.Axis.Y)) {
            return;
        }
        this.destroyTree();
    }

    private void destroyTree() {
        this.destroyConnectedLogs(this.pos, new Counter(128));
    }

    private void destroyConnectedLogs(BlockPos pos, Counter counter) {
        if (counter.isZero()) {
            return;
        }
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    this.check(positions, pos, x, y, z);
                }
            }
        }
        for (BlockPos p : positions) {
            if (counter.isZero()) {
                return;
            }
            this.destroy(p);
            counter.decrement();
            this.destroyConnectedLogs(p, counter);
        }
    }

    private void check(ArrayList<BlockPos> positions, BlockPos pos, int x, int y, int z) {
        if (this.isLog(pos.func_177982_a(x, y, z))) {
            positions.add(pos.func_177982_a(x, y, z));
        }
    }

    private boolean isLog(BlockPos pos) {
        BlockState b = this.world.func_180495_p(pos);
        return Config.getLogTypes().stream().anyMatch(l -> l.equals(b.func_177230_c()));
    }

    private boolean isGround(BlockPos pos) {
        BlockState b = this.world.func_180495_p(pos);
        return Config.getGroundTypes().stream().anyMatch(l -> l.equals(b.func_177230_c()));
    }

    private void destroy(BlockPos pos) {
        if (this.heldItem != null) {
            this.heldItem.func_77973_b().func_179218_a(this.heldItem, (World)this.world, this.world.func_180495_p(pos), pos, (LivingEntity)this.player);
            this.world.func_175655_b(pos, true);
        }
    }

    private class Counter {
        private int i;

        public Counter(int i) {
            this.i = i;
        }

        public boolean isZero() {
            return this.i <= 0;
        }

        public Counter decrement() {
            if (this.i <= 0) {
                return this;
            }
            --this.i;
            return this;
        }
    }
}

