/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.reap;

import de.maxhenkel.reap.Main;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class TreeEvents {
    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        ItemStack heldItem;
        World world = (World)event.getWorld();
        if (!((Boolean)Main.SERVER_CONFIG.treeHarvest.get()).booleanValue() || world.func_201670_d()) {
            return;
        }
        PlayerEntity player = event.getPlayer();
        BlockPos pos = event.getPos();
        if (TreeEvents.canHarvest(pos, player, world, heldItem = player.func_184614_ca())) {
            TreeEvents.destroyTree(player, world, pos, heldItem);
        }
    }

    @SubscribeEvent
    public void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        if (!((Boolean)Main.SERVER_CONFIG.treeHarvest.get()).booleanValue() || !((Boolean)Main.SERVER_CONFIG.dynamicTreeBreakingEnabled.get()).booleanValue()) {
            return;
        }
        PlayerEntity player = event.getPlayer();
        BlockPos pos = event.getPos();
        if (pos == null) {
            return;
        }
        if (TreeEvents.canHarvest(pos, player, player.field_70170_p, player.func_184614_ca())) {
            List<BlockPos> connectedLogs = TreeEvents.getConnectedLogs(player.field_70170_p, pos);
            event.setNewSpeed((float)((double)event.getOriginalSpeed() / Math.min(1.0 + (Double)Main.SERVER_CONFIG.dynamicTreeBreakingPerLog.get() * (double)connectedLogs.size(), (Double)Main.SERVER_CONFIG.dynamicTreeBreakingMinSpeed.get())));
        }
    }

    public static boolean canHarvest(BlockPos pos, PlayerEntity player, World world, ItemStack heldItem) {
        if (player.field_71075_bZ.field_75098_d) {
            return false;
        }
        if (player.func_225608_bj_()) {
            return false;
        }
        if (Main.SERVER_CONFIG.allowedTreeTools.stream().noneMatch(tag -> tag.func_230235_a_((Object)heldItem.func_77973_b()))) {
            return false;
        }
        if (!TreeEvents.isLog(world, pos)) {
            return false;
        }
        if (!TreeEvents.isGround(world, pos.func_177977_b())) {
            return false;
        }
        BlockState state = world.func_180495_p(pos);
        return !state.func_235904_r_().stream().anyMatch(p -> p.equals((Object)RotatedPillarBlock.field_176298_M)) || ((Direction.Axis)state.func_177229_b((Property)RotatedPillarBlock.field_176298_M)).equals((Object)Direction.Axis.Y);
    }

    private static void destroyTree(PlayerEntity player, World world, BlockPos pos, ItemStack heldItem) {
        List<BlockPos> connectedLogs = TreeEvents.getConnectedLogs(world, pos);
        for (BlockPos logPos : connectedLogs) {
            TreeEvents.destroy(world, player, logPos, heldItem);
        }
    }

    private static List<BlockPos> getConnectedLogs(World world, BlockPos pos) {
        BlockPosList positions = new BlockPosList();
        TreeEvents.collectLogs(world, pos, positions);
        return positions;
    }

    private static void collectLogs(World world, BlockPos pos, BlockPosList positions) {
        if (positions.size() >= 128) {
            return;
        }
        ArrayList<BlockPos> posList = new ArrayList<BlockPos>();
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    BlockPos p = pos.func_177982_a(x, y, z);
                    if (!TreeEvents.isLog(world, p)) continue;
                    if (positions.size() <= 128) {
                        if (!positions.add(p)) continue;
                        posList.add(p);
                        continue;
                    }
                    return;
                }
            }
        }
        for (BlockPos p : posList) {
            TreeEvents.collectLogs(world, p, positions);
        }
    }

    private static boolean isLog(World world, BlockPos pos) {
        BlockState b = world.func_180495_p(pos);
        return Main.SERVER_CONFIG.logTypes.stream().anyMatch(tag -> tag.func_230235_a_((Object)b.func_177230_c()));
    }

    private static boolean isGround(World world, BlockPos pos) {
        BlockState b = world.func_180495_p(pos);
        return Main.SERVER_CONFIG.groundTypes.stream().anyMatch(tag -> tag.func_230235_a_((Object)b.func_177230_c()));
    }

    private static void destroy(World world, PlayerEntity player, BlockPos pos, ItemStack heldItem) {
        if (heldItem != null) {
            heldItem.func_77973_b().func_179218_a(heldItem, world, world.func_180495_p(pos), pos, (LivingEntity)player);
            world.func_175655_b(pos, true);
            player.func_71020_j(0.025f);
        }
    }

    private static class BlockPosList
    extends ArrayList<BlockPos> {
        private BlockPosList() {
        }

        @Override
        public boolean add(BlockPos pos) {
            if (!this.contains(pos)) {
                return super.add(pos);
            }
            return false;
        }

        @Override
        public boolean contains(Object o) {
            return this.stream().anyMatch(pos1 -> pos1.equals(o));
        }
    }
}

