/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.config;

import epicsquid.mysticallib.util.ConfigUtil;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="roots")
@Config.LangKey(value="config.roots.category.general")
@Config(modid="roots", name="roots/general", category="main")
public class GeneralConfig {
    @Config.Comment(value={"Client side only: disable elemental soil particles"})
    public static boolean DisableParticles = false;
    @Config.Comment(value={"Set to true to give players the Roots Guide Book upon joining the server"})
    public static boolean GiveBook = false;
    @Config.Comment(value={"Inject some items from Roots into dungeon & other loot chests"})
    public static boolean InjectLoot = true;
    @Config.Comment(value={"Minimum number of pulls for injected loot"})
    public static int InjectMinimum = 1;
    @Config.Comment(value={"Maximum nubmer of pulls for injected loot"})
    public static int InjectMaximum = 1;
    @Config.Comment(value={"1 in X chance per random tick for the Grove Stone to do anything"})
    public static int GroveStoneChance = 2;
    @Config.Comment(value={"Set to false to disable Grove Stone environmental effects"})
    public static boolean EnableGroveStoneEnvironment = true;
    @Config.Comment(value={"Set to true to automatically equip component and apothecary pouches when right-clicking"})
    public static boolean AutoEquipPouches = false;
    @Config.Comment(value={"Set to true to automatically refill your component and apothecary pouches when picking up herbs"})
    public static boolean AutoRefillPouches = false;
    @Config.Comment(value={"The aoe-radius for using runic shears to aoe-shear things"})
    public static int RunicShearsRadius = 15;
    @Config.Comment(value={"List of mod:item:meta (meta optional) of saplings that should be planted in 2x2 by the Spreading Forest ritual"})
    public static String[] TwoByTwoSaplings = new String[]{"thaumcraft:sapling_greatwood"};
    @Config.Ignore
    private static Set<ItemStack> twoByTwoSaplings = null;
    @Config.Comment(value={"List of mod:item:meta (meta optional) of saplings that should be blacklisted from the Spreading Forest ritual"})
    public static String[] SaplingBlacklist = new String[]{"roots:wildwood_sapling", "corvus:frankinsence_sapling", "thebetweenlands:sapling_spirit_tree"};
    @Config.Ignore
    private static Set<ItemStack> saplingBlacklist = null;

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("roots")) {
            ConfigManager.sync((String)"roots", (Config.Type)Config.Type.INSTANCE);
        }
    }

    public static Set<ItemStack> getTwoByTwoSaplings() {
        if (twoByTwoSaplings == null) {
            twoByTwoSaplings = ConfigUtil.parseItemStacksSet((String[])TwoByTwoSaplings);
        }
        return twoByTwoSaplings;
    }

    public static Set<ItemStack> getSaplingBlacklist() {
        if (saplingBlacklist == null) {
            saplingBlacklist = ConfigUtil.parseItemStacksSet((String[])SaplingBlacklist);
        }
        return saplingBlacklist;
    }
}

