/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.entity.ritual;

import epicsquid.mysticallib.network.PacketHandler;
import epicsquid.mysticallib.util.ItemUtil;
import epicsquid.mysticallib.util.Util;
import epicsquid.roots.entity.ritual.EntityRitualBase;
import epicsquid.roots.init.ModRecipes;
import epicsquid.roots.network.fx.MessageOvergrowthEffectFX;
import epicsquid.roots.recipe.TransmutationRecipe;
import epicsquid.roots.ritual.RitualRegistry;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class EntityRitualTransmutation
extends EntityRitualBase {
    protected static Random random = new Random();
    protected static final DataParameter<Integer> lifetime = EntityDataManager.func_187226_a(EntityRitualTransmutation.class, (DataSerializer)DataSerializers.field_187192_b);
    private Set<TransmutationRecipe> recipes = new HashSet<TransmutationRecipe>();

    public EntityRitualTransmutation(World worldIn) {
        super(worldIn);
        this.func_184212_Q().func_187214_a(lifetime, (Object)(RitualRegistry.ritual_transmutation.getDuration() + 20));
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        int curLifetime = (Integer)this.func_184212_Q().func_187225_a(lifetime);
        this.func_184212_Q().func_187227_b(lifetime, (Object)(curLifetime - 1));
        this.func_184212_Q().func_187217_b(lifetime);
        if ((Integer)this.func_184212_Q().func_187225_a(lifetime) < 0) {
            this.func_70106_y();
        }
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (this.field_70173_aa % 100 == 0) {
            List eligiblePositions = Util.getBlocksWithinRadius((World)this.field_70170_p, (BlockPos)this.func_180425_c(), (float)8.0f, (float)8.0f, (float)8.0f, pos -> {
                if (this.field_70170_p.func_175623_d(pos)) {
                    return false;
                }
                IBlockState state = this.field_70170_p.func_180495_p(pos);
                List<TransmutationRecipe> stateRecipes = ModRecipes.getTransmutationRecipes(state);
                if (stateRecipes == null) {
                    return false;
                }
                boolean foundMatch = false;
                for (TransmutationRecipe r : stateRecipes) {
                    if (!r.matches(this.field_70170_p, (BlockPos)pos, state)) continue;
                    foundMatch = true;
                    break;
                }
                if (foundMatch) {
                    this.recipes.addAll(stateRecipes);
                    return true;
                }
                return false;
            });
            if (eligiblePositions.isEmpty()) {
                return;
            }
            BlockPos pos2 = (BlockPos)eligiblePositions.get(random.nextInt(eligiblePositions.size()));
            this.transmuteBlock(this.field_70170_p, pos2);
            PacketHandler.sendToAllTracking((IMessage)new MessageOvergrowthEffectFX(pos2.func_177958_n(), pos2.func_177956_o(), pos2.func_177952_p()), (Entity)this);
        }
    }

    @Override
    public DataParameter<Integer> getLifetime() {
        return lifetime;
    }

    private void transmuteBlock(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        TransmutationRecipe recipe = null;
        for (TransmutationRecipe r : this.recipes) {
            if (!r.matches(world, pos, state)) continue;
            recipe = r;
            break;
        }
        if (recipe == null) {
            return;
        }
        if (recipe.itemOutput()) {
            world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
            ItemUtil.spawnItem((World)world, (BlockPos)pos, (ItemStack)recipe.getEndStack().func_77946_l());
        } else {
            world.func_175656_a(pos, recipe.getEndState());
        }
    }
}

