/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.gui.container;

import epicsquid.roots.recipe.FeyCraftingRecipe;
import epicsquid.roots.tileentity.TileEntityFeyCrafter;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class ContainerFeyCrafter
extends Container {
    private TileEntityFeyCrafter crafter;
    private EntityPlayer player;
    private FeyCraftingRecipe recipe;
    private final InventoryCraftResult craftResult;

    public ContainerFeyCrafter(EntityPlayer player, TileEntityFeyCrafter crafter) {
        this.player = player;
        this.crafter = crafter;
        this.craftResult = new InventoryCraftResult();
        this.createCrafterSlots();
        this.createPlayerInventory(player.field_71071_by);
    }

    private void createCrafterSlots() {
        this.func_75146_a((Slot)new SlotGrid((IItemHandler)this.crafter.inventory, this, 0, 54, 10));
        this.func_75146_a((Slot)new SlotGrid((IItemHandler)this.crafter.inventory, this, 1, 28, 31));
        this.func_75146_a((Slot)new SlotGrid((IItemHandler)this.crafter.inventory, this, 2, 80, 31));
        this.func_75146_a((Slot)new SlotGrid((IItemHandler)this.crafter.inventory, this, 3, 35, 64));
        this.func_75146_a((Slot)new SlotGrid((IItemHandler)this.crafter.inventory, this, 4, 75, 64));
    }

    private void createPlayerInventory(InventoryPlayer inventoryPlayer) {
        int i;
        int xOffset = 8;
        int yOffset = 105;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)inventoryPlayer, j + i * 9 + 9, xOffset + j * 18, yOffset + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot((IInventory)inventoryPlayer, i, xOffset + i * 18, yOffset + 58));
        }
    }

    @Nonnull
    public ItemStack func_82846_b(EntityPlayer playerIn, int index) {
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot == null || !slot.func_75216_d()) {
            return ItemStack.field_190927_a;
        }
        ItemStack original = slot.func_75211_c().func_77946_l();
        ItemStack itemstack = slot.func_75211_c().func_77946_l();
        int end = this.field_75151_b.size();
        if (index < 5 ? !this.func_75135_a(itemstack, 5, end, true) : !this.func_75135_a(itemstack, 0, 5, false)) {
            return ItemStack.field_190927_a;
        }
        slot.func_75218_e();
        if (itemstack.func_190916_E() == original.func_190916_E()) {
            return ItemStack.field_190927_a;
        }
        slot.func_75215_d(itemstack);
        slot.func_190901_a(this.player, itemstack);
        if (slot.func_75216_d() && slot.func_75211_c().func_190926_b()) {
            slot.func_75215_d(ItemStack.field_190927_a);
        }
        return original;
    }

    protected boolean mergeItemStackRefill(@Nonnull ItemStack stack, int startIndex, int endIndex, boolean useEndIndex) {
        if (stack.func_190916_E() <= 0) {
            return false;
        }
        boolean flag1 = false;
        int k = startIndex;
        if (useEndIndex) {
            k = endIndex - 1;
        }
        if (stack.func_77985_e()) {
            while (stack.func_190916_E() > 0 && (!useEndIndex && k < endIndex || useEndIndex && k >= startIndex)) {
                Slot slot = (Slot)this.field_75151_b.get(k);
                ItemStack itemstack1 = slot.func_75211_c();
                if (!itemstack1.func_190926_b() && itemstack1.func_77973_b() == stack.func_77973_b() && (!stack.func_77981_g() || stack.func_77960_j() == itemstack1.func_77960_j()) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)itemstack1) && this.func_94530_a(stack, slot)) {
                    int limit;
                    int l = itemstack1.func_190916_E() + stack.func_190916_E();
                    if (l <= (limit = Math.min(stack.func_77976_d(), slot.func_178170_b(stack)))) {
                        stack.func_190920_e(0);
                        itemstack1.func_190920_e(l);
                        slot.func_75218_e();
                        flag1 = true;
                    } else if (itemstack1.func_190916_E() < limit) {
                        stack.func_190918_g(limit - itemstack1.func_190916_E());
                        itemstack1.func_190920_e(limit);
                        slot.func_75218_e();
                        flag1 = true;
                    }
                }
                if (useEndIndex) {
                    --k;
                    continue;
                }
                ++k;
            }
        }
        return flag1;
    }

    protected boolean mergeItemStackMove(@Nonnull ItemStack stack, int startIndex, int endIndex, boolean useEndIndex) {
        if (stack.func_190916_E() <= 0) {
            return false;
        }
        boolean flag1 = false;
        int k = useEndIndex ? endIndex - 1 : startIndex;
        while (!useEndIndex && k < endIndex || useEndIndex && k >= startIndex) {
            Slot slot = (Slot)this.field_75151_b.get(k);
            ItemStack itemstack1 = slot.func_75211_c();
            if (itemstack1.func_190926_b() && slot.func_75214_a(stack) && this.func_94530_a(stack, slot)) {
                int limit = slot.func_178170_b(stack);
                ItemStack stack2 = stack.func_77946_l();
                if (stack2.func_190916_E() > limit) {
                    stack2.func_190920_e(limit);
                    stack.func_190918_g(limit);
                } else {
                    stack.func_190920_e(0);
                }
                slot.func_75215_d(stack2);
                slot.func_75218_e();
                flag1 = true;
                if (stack.func_190926_b()) break;
            }
            if (useEndIndex) {
                --k;
                continue;
            }
            ++k;
        }
        return flag1;
    }

    public boolean func_94530_a(ItemStack p_94530_1_, Slot p_94530_2_) {
        return p_94530_2_.field_75224_c != this.craftResult && super.func_94530_a(p_94530_1_, p_94530_2_);
    }

    public void func_75130_a(IInventory inventoryIn) {
        this.func_192389_a(this.player.field_70170_p, this.player, null, this.craftResult);
    }

    protected boolean func_75135_a(@Nonnull ItemStack stack, int startIndex, int endIndex, boolean useEndIndex) {
        boolean ret = this.mergeItemStackRefill(stack, startIndex, endIndex, useEndIndex);
        if (!stack.func_190926_b() && stack.func_190916_E() > 0) {
            ret |= this.mergeItemStackMove(stack, startIndex, endIndex, useEndIndex);
        }
        return ret;
    }

    protected void func_192389_a(World world, EntityPlayer player, InventoryCrafting inv, InventoryCraftResult result) {
        List<ItemStack> items = this.crafter.getContents();
        if (this.recipe == null || !this.recipe.matches(items)) {
            this.recipe = this.crafter.getRecipe();
        }
    }

    public boolean getValidStone() {
        return this.crafter.hasValidGroveStone();
    }

    public FeyCraftingRecipe getRecipe() {
        return this.recipe;
    }

    public boolean func_75145_c(@Nonnull EntityPlayer player) {
        BlockPos pos = this.crafter.func_174877_v();
        if (this.crafter.func_145831_w().func_175625_s(pos) != this.crafter) {
            return false;
        }
        return player.func_70092_e((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5) <= 64.0;
    }

    public static class SlotGrid
    extends SlotItemHandler {
        Container eventHandler;

        public SlotGrid(IItemHandler itemHandler, Container eventHandler, int index, int xPosition, int yPosition) {
            super(itemHandler, index, xPosition, yPosition);
            this.eventHandler = eventHandler;
        }

        @Nonnull
        public ItemStack func_75209_a(int amount) {
            ItemStack result = super.func_75209_a(amount);
            this.eventHandler.func_75130_a(null);
            return result;
        }

        public void func_75215_d(@Nonnull ItemStack stack) {
            super.func_75215_d(stack);
            this.eventHandler.func_75130_a(null);
        }
    }
}

