/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.gui.container;

import epicsquid.roots.handler.PouchHandler;
import epicsquid.roots.init.HerbRegistry;
import epicsquid.roots.init.ModItems;
import epicsquid.roots.item.ItemPouch;
import epicsquid.roots.util.PowderInventoryUtil;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class ContainerPouch
extends Container {
    private PouchHandler.PouchItemHandler inventoryHandler;
    private PouchHandler.PouchItemHandler herbsHandler;
    private PouchHandler handler;
    private EntityPlayer player;
    private ItemStack pouch;
    public boolean componentPouch = false;
    private int inventoryEnd;
    private int herbsEnd;

    public ContainerPouch(EntityPlayer player) {
        this.player = player;
        ItemStack main = player.func_184614_ca();
        ItemStack off = player.func_184592_cb();
        ItemStack first = PowderInventoryUtil.getPouch(player);
        ItemStack use = ItemStack.field_190927_a;
        if (main.func_77973_b() instanceof ItemPouch) {
            use = main;
        } else if (off.func_77973_b() instanceof ItemPouch) {
            use = off;
        } else if (first.func_77973_b() instanceof ItemPouch) {
            use = first;
        }
        this.handler = PouchHandler.getHandler(use);
        this.inventoryHandler = this.handler.getInventory();
        this.herbsHandler = this.handler.getHerbs();
        this.pouch = use;
        this.createPlayerInventory(player.field_71071_by);
        this.createPouchSlots();
    }

    private void createPouchSlots() {
        if (this.pouch.func_77973_b() == ModItems.component_pouch) {
            this.createComponentPouchSlots();
            this.componentPouch = true;
        } else {
            this.createApothecaryPouchSlots();
        }
    }

    private void createComponentPouchSlots() {
        int i;
        int xOffset = -13;
        int yOffset = -55;
        int q = 0;
        for (i = 0; i < this.inventoryHandler.getSlots(); ++i) {
            if (i < 5) {
                this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)this.inventoryHandler, q++, xOffset + 11 + i * 21, yOffset + 23));
            }
            if (i >= 5 && i < 9) {
                this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)this.inventoryHandler, q++, xOffset + 22 + (i - 5) * 21, yOffset + 44));
            }
            if (i < 9 || i >= 12) continue;
            this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)this.inventoryHandler, q++, xOffset + 33 + (i - 9) * 21, yOffset + 65));
        }
        this.inventoryEnd = q;
        for (i = 0; i < this.herbsHandler.getSlots(); ++i) {
            if (q < 12 || q >= 18) continue;
            int yPosOffset = q >= 14 ? (q >= 16 ? 42 : 21) : 0;
            this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)this.herbsHandler, i, xOffset + 127 + 21 * (q % 2), yOffset + 23 + yPosOffset));
            ++q;
        }
        this.herbsEnd = q;
    }

    private void createApothecaryPouchSlots() {
        int i;
        int xOffset = -35;
        int yOffset = -63;
        int q = 0;
        for (i = 0; i < this.inventoryHandler.getSlots(); ++i) {
            if (i < 6) {
                this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)this.inventoryHandler, q, xOffset + 25 + 20 * (q % 6), yOffset + 19));
            }
            if (i >= 6 && i < 12) {
                this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)this.inventoryHandler, q, xOffset + 25 + 20 * (q % 6), yOffset + 43));
            }
            if (i >= 12 && i < 18) {
                this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)this.inventoryHandler, q, xOffset + 25 + 20 * (q % 6), yOffset + 66));
            }
            ++q;
        }
        this.inventoryEnd = q;
        for (i = 0; i < this.herbsHandler.getSlots(); ++i) {
            q = this.inventoryEnd + i;
            if (q >= 18 && q < 21) {
                this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)this.herbsHandler, i, xOffset + 149 + 16 * (q % 3), yOffset + 16 + 4 * (q % 2)));
            }
            if (q >= 21 && q < 24) {
                this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)this.herbsHandler, i, xOffset + 149 + 16 * (q % 3), yOffset + 39 + 4 * ((q + 1) % 2)));
            }
            if (q < 24 || q >= 27) continue;
            this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)this.herbsHandler, i, xOffset + 149 + 16 * (q % 3), yOffset + 64 + 4 * (q % 2)));
        }
        this.herbsEnd = q + 1;
    }

    private void createPlayerInventory(InventoryPlayer inventoryPlayer) {
        int i;
        int xOffset = -5;
        int yOffset = 70;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)inventoryPlayer, j + i * 9 + 9, xOffset + j * 18, yOffset + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot((IInventory)inventoryPlayer, i, xOffset + i * 18, yOffset + 58));
        }
    }

    public boolean func_75145_c(@Nonnull EntityPlayer player) {
        return true;
    }

    @Nonnull
    public ItemStack func_82846_b(EntityPlayer playerIn, int index) {
        ItemStack slotStack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        int herbStart = this.inventoryEnd + 36;
        int herbStop = this.herbsEnd + 36;
        if (slot != null && slot.func_75216_d()) {
            ItemStack stack = slot.func_75211_c();
            slotStack = stack.func_77946_l();
            boolean herb = HerbRegistry.isHerb(slotStack.func_77973_b());
            if (index < 36) {
                if (herb && !this.func_75135_a(stack, herbStart, herbStop, false)) {
                    this.handler.saveToStack();
                    return ItemStack.field_190927_a;
                }
                if (!herb && !this.func_75135_a(stack, 36, herbStart, false)) {
                    this.handler.saveToStack();
                    return ItemStack.field_190927_a;
                }
            } else if (!this.func_75135_a(stack, 27, 36, false) && !this.func_75135_a(stack, 0, 27, false)) {
                this.handler.saveToStack();
                return ItemStack.field_190927_a;
            }
            if (stack.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
                this.handler.saveToStack();
            }
            slot.func_75218_e();
        }
        this.handler.saveToStack();
        return slotStack;
    }

    @Nonnull
    public ItemStack func_184996_a(int slotId, int dragType, ClickType clickTypeIn, EntityPlayer player) {
        ItemStack stack;
        if (slotId >= 0 && (stack = this.func_75139_a(slotId).func_75211_c()).func_77973_b() instanceof ItemPouch) {
            return ItemStack.field_190927_a;
        }
        return super.func_184996_a(slotId, dragType, clickTypeIn, player);
    }
}

