/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.integration.crafttweaker.tweaks;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.mc1120.CraftTweaker;
import epicsquid.roots.integration.crafttweaker.Action;
import epicsquid.roots.ritual.RitualBase;
import epicsquid.roots.ritual.RitualRegistry;
import epicsquid.roots.ritual.conditions.ConditionItems;
import epicsquid.roots.ritual.conditions.ICondition;
import epicsquid.roots.util.zen.ZenDocAppend;
import epicsquid.roots.util.zen.ZenDocArg;
import epicsquid.roots.util.zen.ZenDocClass;
import epicsquid.roots.util.zen.ZenDocMethod;
import java.util.List;
import java.util.ListIterator;
import java.util.stream.Stream;
import net.minecraft.item.crafting.Ingredient;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenDocClass(value="mods.roots.Ritual")
@ZenDocAppend(value={"docs/include/ritual.example.md"})
@ZenRegister
@ZenClass(value="mods.roots.Ritual")
public class RitualTweaker {
    @ZenDocMethod(order=1, args={@ZenDocArg(arg="name", info="the name of the ritual whose ingredients you wish to modify"), @ZenDocArg(arg="inputs", info="a list of five ingredients (no more, no less)")})
    @ZenMethod
    public static void modifyRitual(String name, IIngredient[] inputs) {
        if (inputs.length != 5) {
            CraftTweakerAPI.logError((String)("Rituals must have 5 items: " + name));
            return;
        }
        CraftTweaker.LATE_ACTIONS.add(new Modify(name, (Ingredient[])Stream.of(inputs).map(CraftTweakerMC::getIngredient).toArray(Ingredient[]::new)));
    }

    private static class Modify
    extends Action {
        private String name;
        private Ingredient[] inputs;

        private Modify(String name, Ingredient[] inputs) {
            super("Ritual Modification");
            this.name = name;
            this.inputs = inputs;
        }

        public String describe() {
            return "Modifying Ritual named: " + this.name;
        }

        public void apply() {
            RitualBase ritual = RitualRegistry.getRitual(this.name);
            if (ritual == null || ritual.isDisabled()) {
                CraftTweakerAPI.logError((String)("Invalid or disabled ritual or no ritual by the name of \"" + this.name + "\" exists."));
                return;
            }
            ConditionItems newRecipe = new ConditionItems(this.inputs);
            List<ICondition> conditions = ritual.getConditions();
            ListIterator<ICondition> iterator = conditions.listIterator();
            while (iterator.hasNext()) {
                ICondition cond = iterator.next();
                if (!(cond instanceof ConditionItems)) continue;
                iterator.remove();
                iterator.add(newRecipe);
                return;
            }
            ritual.addCondition(newRecipe);
        }
    }
}

