/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.integration.crafttweaker.tweaks;

import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.mc1120.CraftTweaker;
import epicsquid.roots.init.ModRecipes;
import epicsquid.roots.integration.crafttweaker.Action;
import epicsquid.roots.util.zen.ZenDocAppend;
import epicsquid.roots.util.zen.ZenDocArg;
import epicsquid.roots.util.zen.ZenDocClass;
import epicsquid.roots.util.zen.ZenDocMethod;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenDocClass(value="mods.roots.Transmutation")
@ZenDocAppend(value={"docs/include/transmutation.example.md"})
@ZenRegister
@ZenClass(value="mods.roots.Transmutation")
public class TransmutationTweaker {
    @ZenDocMethod(order=1, args={@ZenDocArg(arg="name", info="the name of the recipe being removed")})
    @ZenMethod
    public static void removeRecipe(String name) {
        CraftTweaker.LATE_ACTIONS.add(new Remove(name));
    }

    @ZenDocMethod(order=2, args={@ZenDocArg(arg="name", info="the name of the recipe being added (must be unique)"), @ZenDocArg(arg="state1", info="the initial state of the block as defined as a blockstate"), @ZenDocArg(arg="state2", info="the state that the initial state should be converted into")})
    @ZenMethod
    public static void addBlockToBlockRecipe(String name, crafttweaker.api.block.IBlockState state1, crafttweaker.api.block.IBlockState state2) {
        CraftTweaker.LATE_ACTIONS.add(new BlockToBlock(name, CraftTweakerMC.getBlockState((crafttweaker.api.block.IBlockState)state1), CraftTweakerMC.getBlockState((crafttweaker.api.block.IBlockState)state2)));
    }

    @ZenDocMethod(order=3, args={@ZenDocArg(arg="name", info="the name of the recipe being added (must be unique)"), @ZenDocArg(arg="state", info="the initial state that is looked for when converting (as a block state)"), @ZenDocArg(arg="stack", info="the item stack that replaces the block state")})
    @ZenMethod
    public static void addBlockToItemRecipe(String name, crafttweaker.api.block.IBlockState state, IItemStack stack) {
        CraftTweaker.LATE_ACTIONS.add(new BlockToItem(name, CraftTweakerMC.getBlockState((crafttweaker.api.block.IBlockState)state), CraftTweakerMC.getItemStack((IItemStack)stack)));
    }

    private static class BlockToItem
    extends Action {
        private final IBlockState state;
        private final ItemStack stack;
        private final String name;

        protected BlockToItem(String name, IBlockState state1, ItemStack stack) {
            super("add_block_to_item_transmutation");
            this.state = state1;
            this.stack = stack;
            this.name = name;
        }

        public void apply() {
            ModRecipes.addTransmutationRecipe(this.name, this.state, this.stack);
        }

        public String describe() {
            return String.format("Recipe to turn %s->%s to Transmutation", this.state, this.stack);
        }
    }

    private static class BlockToBlock
    extends Action {
        private final IBlockState state1;
        private final IBlockState state2;
        private final String name;

        protected BlockToBlock(String name, IBlockState state1, IBlockState state2) {
            super("add_block_to_block_transmutation");
            this.name = name;
            this.state1 = state1;
            this.state2 = state2;
        }

        public void apply() {
            ModRecipes.addTransmutationRecipe(this.name, this.state1, this.state2);
        }

        public String describe() {
            return String.format("Recipe to add %s->%s to Transmutation", this.state1, this.state2);
        }
    }

    private static class Remove
    extends Action {
        private final ResourceLocation name;

        public Remove(String name) {
            super("remove_transmutation");
            this.name = name.contains(":") ? new ResourceLocation(name) : new ResourceLocation("roots", name);
        }

        public void apply() {
            ModRecipes.removeTransmutationRecipe(this.name);
        }

        public String describe() {
            return String.format("Recipe to remove %s from Transmutation", this.name);
        }
    }
}

