/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.mechanics;

import epicsquid.mysticallib.util.Util;
import epicsquid.roots.config.CropConfig;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBeetroot;
import net.minecraft.block.BlockCactus;
import net.minecraft.block.BlockChorusFlower;
import net.minecraft.block.BlockCocoa;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockMushroom;
import net.minecraft.block.BlockNetherWart;
import net.minecraft.block.BlockReed;
import net.minecraft.block.BlockStem;
import net.minecraft.block.IGrowable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;

public class Growth {
    private static Set<Block> BLACKLIST = new HashSet<Block>();
    private static Set<IProperty<?>> AGE_PROPERTIES = new HashSet();
    private static Object2IntOpenHashMap<PropertyInteger> AGE_MAP = new Object2IntOpenHashMap();

    public static void addBlacklist(Block ... blocks) {
        BLACKLIST.addAll(Arrays.asList(blocks));
    }

    public static List<BlockPos> collect(World world, BlockPos startPosition, int radiusX, int radiusY, int radiusZ) {
        return Util.getBlocksWithinRadius((World)world, (BlockPos)startPosition, (float)radiusX, (float)radiusY, (float)radiusZ, pos -> Growth.canGrow(world, pos, world.func_180495_p(pos)));
    }

    public static boolean canGrow(World world, BlockPos pos, IBlockState state) {
        if (BLACKLIST.contains(state.func_177230_c())) {
            return false;
        }
        if (CropConfig.getGrowthBlacklist().contains(state.func_177230_c())) {
            return false;
        }
        if (CropConfig.getGrowthModBlacklist().contains(Objects.requireNonNull(state.func_177230_c().getRegistryName()).func_110624_b())) {
            return false;
        }
        if (state.func_177230_c() instanceof IGrowable) {
            return ((IGrowable)state.func_177230_c()).func_176473_a(world, pos, state, true);
        }
        if (state.func_177230_c() == Blocks.field_150436_aH || state.func_177230_c() == Blocks.field_150434_aF) {
            return world.func_175623_d(pos.func_177984_a());
        }
        if (state.func_177230_c() instanceof BlockStem) {
            return true;
        }
        if (state.func_177230_c() instanceof BlockMushroom) {
            return true;
        }
        if (state.func_177230_c() instanceof IPlantable) {
            int n;
            Collection keys = state.func_177227_a();
            IProperty toCheck = null;
            for (IProperty iProperty : AGE_PROPERTIES) {
                if (!keys.contains(iProperty)) continue;
                toCheck = iProperty;
                break;
            }
            if (toCheck == null) {
                for (IProperty iProperty : keys) {
                    if (!iProperty.func_177701_a().contains("age")) continue;
                    AGE_PROPERTIES.add(iProperty);
                    toCheck = iProperty;
                    break;
                }
            }
            if (toCheck == null) {
                return false;
            }
            if (!toCheck.func_177699_b().equals(Integer.class)) {
                return false;
            }
            PropertyInteger prop = (PropertyInteger)toCheck;
            int n2 = AGE_MAP.getInt((Object)prop);
            if (n2 == -1) {
                n = (Integer)Collections.max(prop.func_177700_c());
                AGE_MAP.put((Object)prop, n);
            }
            return (Integer)state.func_177229_b((IProperty)prop) < n;
        }
        return false;
    }

    static {
        AGE_MAP.defaultReturnValue(-1);
        AGE_PROPERTIES.add((IProperty<?>)BlockReed.field_176355_a);
        AGE_PROPERTIES.add((IProperty<?>)BlockChorusFlower.field_185607_a);
        AGE_PROPERTIES.add((IProperty<?>)BlockCactus.field_176587_a);
        AGE_PROPERTIES.add((IProperty<?>)BlockBeetroot.field_185531_a);
        AGE_PROPERTIES.add((IProperty<?>)BlockStem.field_176484_a);
        AGE_PROPERTIES.add((IProperty<?>)BlockNetherWart.field_176486_a);
        AGE_PROPERTIES.add((IProperty<?>)BlockCrops.field_176488_a);
        AGE_PROPERTIES.add((IProperty<?>)BlockCocoa.field_176501_a);
        AGE_MAP.put((Object)BlockReed.field_176355_a, 15);
        AGE_MAP.put((Object)BlockChorusFlower.field_185607_a, 5);
        AGE_MAP.put((Object)BlockCactus.field_176587_a, 15);
        AGE_MAP.put((Object)BlockBeetroot.field_185531_a, 3);
        AGE_MAP.put((Object)BlockStem.field_176484_a, 7);
        AGE_MAP.put((Object)BlockNetherWart.field_176486_a, 3);
        AGE_MAP.put((Object)BlockCrops.field_176488_a, 7);
        AGE_MAP.put((Object)BlockCocoa.field_176501_a, 2);
        Growth.addBlacklist(new Block[]{Blocks.field_150329_H, Blocks.field_150398_cm, Blocks.field_150349_c, Blocks.field_150398_cm, Blocks.field_150328_O, Blocks.field_150327_N});
    }
}

