/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.network.fx;

import epicsquid.mysticallib.util.Util;
import epicsquid.roots.particle.ParticleUtil;
import epicsquid.roots.spell.SpellRadiance;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MessageRadianceBeamFX
implements IMessage {
    private double posX = 0.0;
    private double posY = 0.0;
    private double posZ = 0.0;
    private UUID id = null;

    public MessageRadianceBeamFX() {
    }

    public MessageRadianceBeamFX(UUID id, double x, double y, double z) {
        this.posX = x;
        this.posY = y;
        this.posZ = z;
        this.id = id;
    }

    public void fromBytes(ByteBuf buf) {
        this.posX = buf.readDouble();
        this.posY = buf.readDouble();
        this.posZ = buf.readDouble();
        this.id = new UUID(buf.readLong(), buf.readLong());
    }

    public void toBytes(ByteBuf buf) {
        buf.writeDouble(this.posX);
        buf.writeDouble(this.posY);
        buf.writeDouble(this.posZ);
        buf.writeLong(this.id.getMostSignificantBits());
        buf.writeLong(this.id.getLeastSignificantBits());
    }

    public static float getColorCycle(float ticks) {
        return (MathHelper.func_76126_a((float)((float)Math.toRadians(ticks))) + 1.0f) / 2.0f;
    }

    public static class MessageHolder
    implements IMessageHandler<MessageRadianceBeamFX, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(MessageRadianceBeamFX message, MessageContext ctx) {
            WorldClient world = Minecraft.func_71410_x().field_71441_e;
            EntityPlayer player = world.func_152378_a(message.id);
            if (player != null) {
                float distance = 32.0f;
                RayTraceResult result = player.field_70170_p.func_147447_a(player.func_174791_d().func_72441_c(0.0, (double)player.func_70047_e(), 0.0), player.func_174791_d().func_72441_c(0.0, (double)player.func_70047_e(), 0.0).func_178787_e(player.func_70040_Z().func_186678_a((double)distance)), false, true, true);
                Vec3d direction = player.func_70040_Z();
                ArrayList<Vec3d> positions = new ArrayList<Vec3d>();
                float offX = 0.5f * (float)Math.sin(Math.toRadians(-90.0f - player.field_70177_z));
                float offZ = 0.5f * (float)Math.cos(Math.toRadians(-90.0f - player.field_70177_z));
                positions.add(new Vec3d(player.field_70165_t + (double)offX, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v + (double)offZ));
                if (result != null) {
                    positions.add(result.field_72307_f);
                    if (result.field_72313_a == RayTraceResult.Type.BLOCK) {
                        Vec3i hitSide = result.field_178784_b.func_176730_m();
                        float xCoeff = 1.0f;
                        if (hitSide.func_177958_n() != 0) {
                            xCoeff = -1.0f;
                        }
                        float yCoeff = 1.0f;
                        if (hitSide.func_177956_o() != 0) {
                            yCoeff = -1.0f;
                        }
                        float zCoeff = 1.0f;
                        if (hitSide.func_177952_p() != 0) {
                            zCoeff = -1.0f;
                        }
                        direction = new Vec3d(direction.field_72450_a * (double)xCoeff, direction.field_72448_b * (double)yCoeff, direction.field_72449_c * (double)zCoeff);
                        if ((distance = (float)((double)distance - result.field_72307_f.func_178788_d(player.func_174791_d()).func_72433_c())) > 0.0f) {
                            RayTraceResult result2 = player.field_70170_p.func_72933_a(result.field_72307_f.func_178787_e(direction.func_186678_a(0.1)), result.field_72307_f.func_178787_e(direction.func_186678_a((double)distance)));
                            if (result2 != null) {
                                positions.add(result2.field_72307_f);
                                if (result2.field_72313_a == RayTraceResult.Type.BLOCK) {
                                    hitSide = result2.field_178784_b.func_176730_m();
                                    xCoeff = 1.0f;
                                    if (hitSide.func_177958_n() != 0) {
                                        xCoeff = -1.0f;
                                    }
                                    yCoeff = 1.0f;
                                    if (hitSide.func_177956_o() != 0) {
                                        yCoeff = -1.0f;
                                    }
                                    zCoeff = 1.0f;
                                    if (hitSide.func_177952_p() != 0) {
                                        zCoeff = -1.0f;
                                    }
                                    direction = new Vec3d(direction.field_72450_a * (double)xCoeff, direction.field_72448_b * (double)yCoeff, direction.field_72449_c * (double)zCoeff);
                                    if ((distance = (float)((double)distance - result2.field_72307_f.func_178788_d(player.func_174791_d()).func_72433_c())) > 0.0f) {
                                        RayTraceResult result3 = player.field_70170_p.func_72933_a(result2.field_72307_f.func_178787_e(direction.func_186678_a(0.1)), result2.field_72307_f.func_178787_e(direction.func_186678_a((double)distance)));
                                        if (result3 != null) {
                                            positions.add(result3.field_72307_f);
                                        } else {
                                            positions.add(result2.field_72307_f.func_178787_e(direction.func_186678_a((double)distance)));
                                        }
                                    }
                                }
                            } else {
                                positions.add(result.field_72307_f.func_178787_e(direction.func_186678_a((double)distance)));
                            }
                        }
                    }
                } else {
                    positions.add(player.func_174791_d().func_72441_c(0.0, (double)player.func_70047_e(), 0.0).func_178787_e(player.func_70040_Z().func_186678_a((double)distance)));
                }
                if (positions.size() > 1) {
                    double totalDist = 0.0;
                    for (int i = 0; i < positions.size() - 1; ++i) {
                        totalDist += ((Vec3d)positions.get(i)).func_178788_d((Vec3d)positions.get(i + 1)).func_72433_c();
                    }
                    double alphaDist = 0.0;
                    for (int i = 0; i < positions.size() - 1; ++i) {
                        double dist = ((Vec3d)positions.get(i)).func_178788_d((Vec3d)positions.get(i + 1)).func_72433_c();
                        for (double j = 0.0; j < dist; j += 0.15) {
                            double x = ((Vec3d)positions.get((int)i)).field_72450_a * (1.0 - j / dist) + ((Vec3d)positions.get((int)(i + 1))).field_72450_a * (j / dist);
                            double y = ((Vec3d)positions.get((int)i)).field_72448_b * (1.0 - j / dist) + ((Vec3d)positions.get((int)(i + 1))).field_72448_b * (j / dist);
                            double z = ((Vec3d)positions.get((int)i)).field_72449_c * (1.0 - j / dist) + ((Vec3d)positions.get((int)(i + 1))).field_72449_c * (j / dist);
                            alphaDist += 0.15;
                            if (Util.rand.nextBoolean()) {
                                ParticleUtil.spawnParticleStarNoGravity((World)world, (float)x, (float)y, (float)z, 0.0f, 0.0f, 0.0f, SpellRadiance.instance.getRed1() * 255.0f, SpellRadiance.instance.getGreen1() * 255.0f, SpellRadiance.instance.getBlue1() * 255.0f, 0.75f * (float)(1.0 - alphaDist / totalDist), 3.0f + 3.0f * Util.rand.nextFloat(), 14);
                                continue;
                            }
                            ParticleUtil.spawnParticleStarNoGravity((World)world, (float)x, (float)y, (float)z, 0.0f, 0.0f, 0.0f, SpellRadiance.instance.getRed2() * 255.0f, SpellRadiance.instance.getGreen2() * 255.0f, SpellRadiance.instance.getBlue2() * 255.0f, 0.75f * (float)(1.0 - alphaDist / totalDist), 3.0f + 3.0f * Util.rand.nextFloat(), 14);
                        }
                    }
                }
            }
            return null;
        }
    }
}

