/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.recipe;

import epicsquid.roots.util.StateUtil;
import epicsquid.roots.util.types.RegistryItem;
import epicsquid.roots.util.types.WorldPosStatePredicate;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TransmutationRecipe
extends RegistryItem {
    private IBlockState startState;
    private Block startBlock;
    private IBlockState endState;
    private ItemStack endStack;
    private WorldPosStatePredicate condition = (a, b, c) -> true;

    public TransmutationRecipe(ResourceLocation name, Block startBlock, ItemStack endState, WorldPosStatePredicate condition) {
        this.setRegistryName(name);
        this.startBlock = startBlock;
        this.endStack = endState;
        this.endState = null;
        if (condition != null) {
            this.condition = condition;
        }
    }

    public TransmutationRecipe(ResourceLocation name, Block startBlock, IBlockState endState, WorldPosStatePredicate condition) {
        this.setRegistryName(name);
        this.startBlock = startBlock;
        this.endState = endState;
        if (condition != null) {
            this.condition = condition;
        }
    }

    public TransmutationRecipe(ResourceLocation name, IBlockState startState, IBlockState endState, WorldPosStatePredicate condition) {
        this.setRegistryName(name);
        this.startBlock = null;
        this.startState = startState;
        this.endState = endState;
        if (condition != null) {
            this.condition = condition;
        }
    }

    public TransmutationRecipe(ResourceLocation name, IBlockState startState, ItemStack endState, WorldPosStatePredicate condition) {
        this.setRegistryName(name);
        this.startBlock = null;
        this.startState = startState;
        this.endStack = endState;
        this.endState = null;
        if (condition != null) {
            this.condition = condition;
        }
    }

    public boolean itemOutput() {
        return this.endStack != null;
    }

    public Block getStartBlock() {
        return this.startBlock;
    }

    public IBlockState getStartState() {
        if (this.startState == null && this.startBlock != null) {
            return this.startBlock.func_176223_P();
        }
        return this.startState;
    }

    public ItemStack getEndStack() {
        return this.endStack;
    }

    public IBlockState getEndState() {
        return this.endState;
    }

    public WorldPosStatePredicate getCondition() {
        return this.condition;
    }

    public boolean matches(Block block) {
        return this.matches(block.func_176223_P());
    }

    public boolean matches(IBlockState start) {
        if (this.startState != null) {
            return StateUtil.compareStates(this.startState, start);
        }
        return this.startBlock == start.func_177230_c();
    }

    public boolean matches(World world, BlockPos pos, IBlockState state) {
        return (this.startBlock != null && this.startBlock == state.func_177230_c() || this.startState != null && StateUtil.compareStates(this.startState, state)) && (this.getCondition() == null || this.getCondition().test(world, pos, state));
    }

    public boolean matches(World world, BlockPos pos) {
        return this.matches(world, pos, world.func_180495_p(pos));
    }

    public String getKey() {
        return "roots.ritual.transmutation." + this.getRegistryName().func_110623_a();
    }
}

