/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.ritual.conditions;

import epicsquid.roots.ritual.conditions.ICondition;
import epicsquid.roots.tileentity.TileEntityBonfire;
import javax.annotation.Nullable;
import net.minecraft.block.BlockNewLog;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public class ConditionTrees
implements ICondition {
    private final BlockPlanks.EnumType treeType;
    private final int amount;

    public ConditionTrees(BlockPlanks.EnumType treeType, int amount) {
        this.treeType = treeType;
        this.amount = amount;
    }

    public BlockPlanks.EnumType getTreeType() {
        return this.treeType;
    }

    public int getAmount() {
        return this.amount;
    }

    @Override
    public boolean checkCondition(TileEntityBonfire tile, EntityPlayer player) {
        return this.getTreeAmount(tile.func_145831_w(), tile.func_174877_v()) >= this.amount;
    }

    @Override
    @Nullable
    public ITextComponent failMessage() {
        return new TextComponentTranslation("roots.ritual.condition.trees", new Object[]{new TextComponentTranslation("roots.ritual.condition.trees.types", new Object[]{this.getAmount(), new TextComponentTranslation(this.getTreeType().func_176840_c(), new Object[0])})});
    }

    private int getTreeAmount(World world, BlockPos pos) {
        int treeCount = 0;
        for (int i = -9; i < 10; ++i) {
            for (int j = -9; j < 10; ++j) {
                IBlockState state = world.func_180495_p(pos.func_177982_a(i, 1, j));
                if (state.func_177230_c() instanceof BlockOldLog) {
                    if (state.func_177229_b((IProperty)BlockOldLog.field_176301_b) != this.treeType) continue;
                    ++treeCount;
                    continue;
                }
                if (!(state.func_177230_c() instanceof BlockNewLog) || state.func_177229_b((IProperty)BlockNewLog.field_176300_b) != this.treeType) continue;
                ++treeCount;
            }
        }
        return treeCount;
    }
}

